
package io.cucumber.messages.types;

import java.util.HashMap;
import java.util.Map;


/**
 * //// Attachments (parse errors, execution errors, screenshots, links...)
 * 
 * *
 *  An attachment represents any kind of data associated with a line in a
 *  [Source](#io.cucumber.messages.Source) file. It can be used for:
 * 
 *  * Syntax errors during parse time
 *  * Screenshots captured and attached during execution
 *  * Logs captured and attached during execution
 * 
 *  It is not to be used for runtime errors raised/thrown during execution. This
 *  is captured in `TestResult`.
 * 
 */
public class Attachment {

    /**
     * *
     *  The body of the attachment. If `contentEncoding` is `IDENTITY`, the attachment
     *  is simply the string. If it's `BASE64`, the string should be Base64 decoded to
     *  obtain the attachment.
     * (Required)
     * 
     */
    private String body;
    /**
     * *
     *  Whether to interpret `body` "as-is" (IDENTITY) or if it needs to be Base64-decoded (BASE64).
     * 
     *  Content encoding is *not* determined by the media type, but rather by the type
     *  of the object being attached:
     * 
     *  - string => IDENTITY
     *  - byte array => BASE64
     *  - stream => BASE64
     * (Required)
     * 
     */
    private Attachment.ContentEncoding contentEncoding;
    /**
     * *
     *  Suggested file name of the attachment. (Provided by the user as an argument to `attach`)
     * 
     */
    private String fileName;
    /**
     * *
     *  The media type of the data. This can be any valid
     *  [IANA Media Type](https://www.iana.org/assignments/media-types/media-types.xhtml)
     *  as well as Cucumber-specific media types such as `text/x.cucumber.gherkin+plain`
     *  and `text/x.cucumber.stacktrace+plain`
     * (Required)
     * 
     */
    private String mediaType;
    /**
     * //// Source
     * 
     * *
     *  A source file, typically a Gherkin document or Java/Ruby/JavaScript source code
     * 
     */
    private Source source;
    private String testCaseStartedId;
    private String testStepId;
    /**
     * *
     *  A URL where the attachment can be retrieved. This field should not be set by Cucumber.
     *  It should be set by a program that reads a message stream and does the following for
     *  each Attachment message:
     * 
     *  - Writes the body (after base64 decoding if necessary) to a new file.
     *  - Sets `body` and `contentEncoding` to `null`
     *  - Writes out the new attachment message
     * 
     *  This will result in a smaller message stream, which can improve performance and
     *  reduce bandwidth of message consumers. It also makes it easier to process and download attachments
     *  separately from reports.
     * 
     */
    private String url;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Attachment() {
    }

    /**
     * 
     * @param fileName
     * @param contentEncoding
     * @param mediaType
     * @param source
     * @param body
     * @param testStepId
     * @param testCaseStartedId
     * @param url
     */
    public Attachment(String body, Attachment.ContentEncoding contentEncoding, String fileName, String mediaType, Source source, String testCaseStartedId, String testStepId, String url) {
        super();
        this.body = body;
        this.contentEncoding = contentEncoding;
        this.fileName = fileName;
        this.mediaType = mediaType;
        this.source = source;
        this.testCaseStartedId = testCaseStartedId;
        this.testStepId = testStepId;
        this.url = url;
    }

    /**
     * *
     *  The body of the attachment. If `contentEncoding` is `IDENTITY`, the attachment
     *  is simply the string. If it's `BASE64`, the string should be Base64 decoded to
     *  obtain the attachment.
     * (Required)
     * 
     */
    public String getBody() {
        return body;
    }

    /**
     * *
     *  The body of the attachment. If `contentEncoding` is `IDENTITY`, the attachment
     *  is simply the string. If it's `BASE64`, the string should be Base64 decoded to
     *  obtain the attachment.
     * (Required)
     * 
     */
    public void setBody(String body) {
        this.body = body;
    }

    /**
     * *
     *  Whether to interpret `body` "as-is" (IDENTITY) or if it needs to be Base64-decoded (BASE64).
     * 
     *  Content encoding is *not* determined by the media type, but rather by the type
     *  of the object being attached:
     * 
     *  - string => IDENTITY
     *  - byte array => BASE64
     *  - stream => BASE64
     * (Required)
     * 
     */
    public Attachment.ContentEncoding getContentEncoding() {
        return contentEncoding;
    }

    /**
     * *
     *  Whether to interpret `body` "as-is" (IDENTITY) or if it needs to be Base64-decoded (BASE64).
     * 
     *  Content encoding is *not* determined by the media type, but rather by the type
     *  of the object being attached:
     * 
     *  - string => IDENTITY
     *  - byte array => BASE64
     *  - stream => BASE64
     * (Required)
     * 
     */
    public void setContentEncoding(Attachment.ContentEncoding contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    /**
     * *
     *  Suggested file name of the attachment. (Provided by the user as an argument to `attach`)
     * 
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * *
     *  Suggested file name of the attachment. (Provided by the user as an argument to `attach`)
     * 
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * *
     *  The media type of the data. This can be any valid
     *  [IANA Media Type](https://www.iana.org/assignments/media-types/media-types.xhtml)
     *  as well as Cucumber-specific media types such as `text/x.cucumber.gherkin+plain`
     *  and `text/x.cucumber.stacktrace+plain`
     * (Required)
     * 
     */
    public String getMediaType() {
        return mediaType;
    }

    /**
     * *
     *  The media type of the data. This can be any valid
     *  [IANA Media Type](https://www.iana.org/assignments/media-types/media-types.xhtml)
     *  as well as Cucumber-specific media types such as `text/x.cucumber.gherkin+plain`
     *  and `text/x.cucumber.stacktrace+plain`
     * (Required)
     * 
     */
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    /**
     * //// Source
     * 
     * *
     *  A source file, typically a Gherkin document or Java/Ruby/JavaScript source code
     * 
     */
    public Source getSource() {
        return source;
    }

    /**
     * //// Source
     * 
     * *
     *  A source file, typically a Gherkin document or Java/Ruby/JavaScript source code
     * 
     */
    public void setSource(Source source) {
        this.source = source;
    }

    public String getTestCaseStartedId() {
        return testCaseStartedId;
    }

    public void setTestCaseStartedId(String testCaseStartedId) {
        this.testCaseStartedId = testCaseStartedId;
    }

    public String getTestStepId() {
        return testStepId;
    }

    public void setTestStepId(String testStepId) {
        this.testStepId = testStepId;
    }

    /**
     * *
     *  A URL where the attachment can be retrieved. This field should not be set by Cucumber.
     *  It should be set by a program that reads a message stream and does the following for
     *  each Attachment message:
     * 
     *  - Writes the body (after base64 decoding if necessary) to a new file.
     *  - Sets `body` and `contentEncoding` to `null`
     *  - Writes out the new attachment message
     * 
     *  This will result in a smaller message stream, which can improve performance and
     *  reduce bandwidth of message consumers. It also makes it easier to process and download attachments
     *  separately from reports.
     * 
     */
    public String getUrl() {
        return url;
    }

    /**
     * *
     *  A URL where the attachment can be retrieved. This field should not be set by Cucumber.
     *  It should be set by a program that reads a message stream and does the following for
     *  each Attachment message:
     * 
     *  - Writes the body (after base64 decoding if necessary) to a new file.
     *  - Sets `body` and `contentEncoding` to `null`
     *  - Writes out the new attachment message
     * 
     *  This will result in a smaller message stream, which can improve performance and
     *  reduce bandwidth of message consumers. It also makes it easier to process and download attachments
     *  separately from reports.
     * 
     */
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Attachment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("body");
        sb.append('=');
        sb.append(((this.body == null)?"<null>":this.body));
        sb.append(',');
        sb.append("contentEncoding");
        sb.append('=');
        sb.append(((this.contentEncoding == null)?"<null>":this.contentEncoding));
        sb.append(',');
        sb.append("fileName");
        sb.append('=');
        sb.append(((this.fileName == null)?"<null>":this.fileName));
        sb.append(',');
        sb.append("mediaType");
        sb.append('=');
        sb.append(((this.mediaType == null)?"<null>":this.mediaType));
        sb.append(',');
        sb.append("source");
        sb.append('=');
        sb.append(((this.source == null)?"<null>":this.source));
        sb.append(',');
        sb.append("testCaseStartedId");
        sb.append('=');
        sb.append(((this.testCaseStartedId == null)?"<null>":this.testCaseStartedId));
        sb.append(',');
        sb.append("testStepId");
        sb.append('=');
        sb.append(((this.testStepId == null)?"<null>":this.testStepId));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.fileName == null)? 0 :this.fileName.hashCode()));
        result = ((result* 31)+((this.contentEncoding == null)? 0 :this.contentEncoding.hashCode()));
        result = ((result* 31)+((this.mediaType == null)? 0 :this.mediaType.hashCode()));
        result = ((result* 31)+((this.source == null)? 0 :this.source.hashCode()));
        result = ((result* 31)+((this.body == null)? 0 :this.body.hashCode()));
        result = ((result* 31)+((this.testStepId == null)? 0 :this.testStepId.hashCode()));
        result = ((result* 31)+((this.testCaseStartedId == null)? 0 :this.testCaseStartedId.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Attachment) == false) {
            return false;
        }
        Attachment rhs = ((Attachment) other);
        return (((((((((this.fileName == rhs.fileName)||((this.fileName!= null)&&this.fileName.equals(rhs.fileName)))&&((this.contentEncoding == rhs.contentEncoding)||((this.contentEncoding!= null)&&this.contentEncoding.equals(rhs.contentEncoding))))&&((this.mediaType == rhs.mediaType)||((this.mediaType!= null)&&this.mediaType.equals(rhs.mediaType))))&&((this.source == rhs.source)||((this.source!= null)&&this.source.equals(rhs.source))))&&((this.body == rhs.body)||((this.body!= null)&&this.body.equals(rhs.body))))&&((this.testStepId == rhs.testStepId)||((this.testStepId!= null)&&this.testStepId.equals(rhs.testStepId))))&&((this.testCaseStartedId == rhs.testCaseStartedId)||((this.testCaseStartedId!= null)&&this.testCaseStartedId.equals(rhs.testCaseStartedId))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))));
    }


    /**
     * *
     *  Whether to interpret `body` "as-is" (IDENTITY) or if it needs to be Base64-decoded (BASE64).
     * 
     *  Content encoding is *not* determined by the media type, but rather by the type
     *  of the object being attached:
     * 
     *  - string => IDENTITY
     *  - byte array => BASE64
     *  - stream => BASE64
     * 
     */
    public enum ContentEncoding {

        IDENTITY("IDENTITY"),
        BASE_64("BASE64");
        private final String value;
        private final static Map<String, Attachment.ContentEncoding> CONSTANTS = new HashMap<String, Attachment.ContentEncoding>();

        static {
            for (Attachment.ContentEncoding c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ContentEncoding(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static Attachment.ContentEncoding fromValue(String value) {
            Attachment.ContentEncoding constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
