/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages;

public interface IdGenerator {
    public String newId();

    public static class UUID
    implements IdGenerator {
        @Override
        public String newId() {
            return java.util.UUID.randomUUID().toString();
        }
    }

    public static class Incrementing
    implements IdGenerator {
        private int next = 0;

        @Override
        public String newId() {
            return Integer.toString(this.next++);
        }
    }
}

