/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.ndjson.internal.com.fasterxml.jackson.datatype.jdk8;

import io.cucumber.messages.ndjson.internal.com.fasterxml.jackson.core.JsonGenerator;
import io.cucumber.messages.ndjson.internal.com.fasterxml.jackson.core.JsonParser;
import io.cucumber.messages.ndjson.internal.com.fasterxml.jackson.databind.JavaType;
import io.cucumber.messages.ndjson.internal.com.fasterxml.jackson.databind.JsonMappingException;
import io.cucumber.messages.ndjson.internal.com.fasterxml.jackson.databind.SerializerProvider;
import io.cucumber.messages.ndjson.internal.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.cucumber.messages.ndjson.internal.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import io.cucumber.messages.ndjson.internal.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.OptionalInt;

final class OptionalIntSerializer
extends StdScalarSerializer<OptionalInt> {
    private static final long serialVersionUID = 1L;
    static final OptionalIntSerializer INSTANCE = new OptionalIntSerializer();

    public OptionalIntSerializer() {
        super(OptionalInt.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, OptionalInt value) {
        return value == null || !value.isPresent();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.INT);
        }
    }

    @Override
    public void serialize(OptionalInt value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value.isPresent()) {
            gen.writeNumber(value.getAsInt());
        } else {
            gen.writeNull();
        }
    }
}

