/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class AstNode {
    private final Map<Parser.RuleType, List<Object>> subItems = new EnumMap<Parser.RuleType, List<Object>>(Parser.RuleType.class);
    final Parser.RuleType ruleType;

    AstNode(Parser.RuleType ruleType) {
        this.ruleType = ruleType;
    }

    void add(Parser.RuleType ruleType, Object obj) {
        List<Object> items = this.subItems.get((Object)ruleType);
        if (items == null) {
            items = new ArrayList<Object>();
            this.subItems.put(ruleType, items);
        }
        items.add(obj);
    }

    <T> T getSingle(Parser.RuleType ruleType, T defaultResult) {
        List<Object> items = this.subItems.get((Object)ruleType);
        return (T)(items == null ? defaultResult : items.get(0));
    }

    <T> List<T> getItems(Parser.RuleType ruleType) {
        List<Object> items = this.subItems.get((Object)ruleType);
        if (items == null) {
            return Collections.emptyList();
        }
        return items;
    }

    Token getToken(Parser.TokenType tokenType) {
        return Objects.requireNonNull(this.getSingle(tokenType.ruleType, null));
    }

    List<Token> getTokens(Parser.TokenType tokenType) {
        return this.getItems(tokenType.ruleType);
    }
}

