/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import java.util.AbstractMap;
import java.util.Map;

class StringUtils {
    private static final char[] WHITESPACE_CHARS = new char[]{' ', '\t', '\n', '\u000b', '\f', '\r'};
    private static final char[] WHITESPACE_CHARS_EXTENDED = new char[]{' ', '\t', '\n', '\u000b', '\f', '\r', '\u0085', '\u00a0'};
    private static final char[] WHITESPACE_CHARS_EXTENDED_KEEP_NEW_LINES = new char[]{' ', '\t', '\u000b', '\f', '\r', '\u0085', '\u00a0'};

    StringUtils() {
    }

    static String rtrim(String s) {
        int end;
        if (s.isEmpty()) {
            return s;
        }
        int length = s.length();
        for (end = length - 1; end >= 0 && StringUtils.contains(WHITESPACE_CHARS_EXTENDED, s.charAt(end)); --end) {
        }
        return s.substring(0, end + 1);
    }

    static Map.Entry<String, Integer> trimAndIndentKeepNewLines(String input) {
        return StringUtils.trimAndIndent(input, WHITESPACE_CHARS_EXTENDED_KEEP_NEW_LINES);
    }

    static Map.Entry<String, Integer> trimAndIndent(String input) {
        return StringUtils.trimAndIndent(input, WHITESPACE_CHARS_EXTENDED);
    }

    private static Map.Entry<String, Integer> trimAndIndent(String input, char[] whitespaceChars) {
        if (input.isEmpty()) {
            return new AbstractMap.SimpleEntry<String, Integer>("", 0);
        }
        int start = StringUtils.findFirstIndexNotIn(input, input.length(), whitespaceChars);
        int end = StringUtils.findLastIndexNotIn(input, start, whitespaceChars);
        String trimmed = input.substring(start, end);
        int indent = input.codePointCount(0, start);
        return new AbstractMap.SimpleEntry<String, Integer>(trimmed, indent);
    }

    static String removeComments(String input) {
        int start;
        if (input.isEmpty()) {
            return input;
        }
        int length = input.length();
        for (start = 0; !(start >= length - 1 || StringUtils.contains(WHITESPACE_CHARS, input.charAt(start)) && input.charAt(start + 1) == '#'); ++start) {
        }
        return input.substring(0, start < length - 1 ? start : start + 1);
    }

    static boolean containsWhiteSpace(String input) {
        return StringUtils.findFirstIndexIn(input, WHITESPACE_CHARS) != -1;
    }

    private static int findFirstIndexNotIn(String input, int endIndex, char[] characters) {
        int start;
        for (start = 0; start < endIndex && StringUtils.contains(characters, input.charAt(start)); ++start) {
        }
        return start;
    }

    private static int findLastIndexNotIn(String input, int beginIndex, char[] characters) {
        int end;
        for (end = input.length(); end > beginIndex && StringUtils.contains(characters, input.charAt(end - 1)); --end) {
        }
        return end;
    }

    private static int findFirstIndexIn(String input, char[] characters) {
        int length = input.length();
        for (int i = 0; i < length; ++i) {
            if (!StringUtils.contains(characters, input.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static boolean contains(char[] characters, char c) {
        char[] cArray = characters;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character candidate = Character.valueOf(cArray[i]);
            if (candidate.charValue() != c) continue;
            return true;
        }
        return false;
    }
}

