/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.Token;
import io.cucumber.messages.types.Location;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class ParserException
extends RuntimeException {
    final Location location;

    protected ParserException(String message) {
        super(message);
        this.location = null;
    }

    protected ParserException(String message, Location location) {
        super(ParserException.createMessage(message, location));
        this.location = location;
    }

    private static String createMessage(String message, Location location) {
        if (location == null) {
            return String.format("(-1,0): %s", message);
        }
        Long line = location.getLine();
        Long column = location.getColumn().orElse(0L);
        return String.format("(%s:%s): %s", line, column, message);
    }

    static class CompositeParserException
    extends ParserException {
        final List<ParserException> errors;

        CompositeParserException(List<ParserException> errors) {
            super(CompositeParserException.getMessage(errors));
            this.errors = Collections.unmodifiableList(errors);
        }

        private static String getMessage(List<ParserException> errors) {
            if (errors == null) {
                throw new NullPointerException("errors");
            }
            return "Parser errors:\n" + errors.stream().map(Throwable::getMessage).collect(Collectors.joining("\n"));
        }
    }

    static class UnexpectedEOFException
    extends ParserException {
        final String stateComment;
        final List<String> expectedTokenTypes;

        UnexpectedEOFException(Token receivedToken, List<String> expectedTokenTypes, String stateComment) {
            super(UnexpectedEOFException.getMessage(expectedTokenTypes), receivedToken.location);
            this.expectedTokenTypes = expectedTokenTypes;
            this.stateComment = stateComment;
        }

        private static String getMessage(List<String> expectedTokenTypes) {
            return String.format("unexpected end of file, expected: %s", String.join((CharSequence)", ", expectedTokenTypes));
        }
    }

    static class UnexpectedTokenException
    extends ParserException {
        String stateComment;
        final Token receivedToken;
        final List<String> expectedTokenTypes;

        UnexpectedTokenException(Token receivedToken, List<String> expectedTokenTypes, String stateComment) {
            super(UnexpectedTokenException.getMessage(receivedToken, expectedTokenTypes), UnexpectedTokenException.getLocation(receivedToken));
            this.receivedToken = receivedToken;
            this.expectedTokenTypes = expectedTokenTypes;
            this.stateComment = stateComment;
        }

        private static String getMessage(Token receivedToken, List<String> expectedTokenTypes) {
            return String.format("expected: %s, got '%s'", String.join((CharSequence)", ", expectedTokenTypes), receivedToken.getTokenValue());
        }

        private static Location getLocation(Token receivedToken) {
            if (receivedToken.location.getColumn().isPresent()) {
                return receivedToken.location;
            }
            int column = 1 + receivedToken.line.getIndent();
            return Locations.atColumn(receivedToken.location, column);
        }
    }

    static class NoSuchLanguageException
    extends ParserException {
        NoSuchLanguageException(String language, Location location) {
            super("Language not supported: " + language, location);
        }
    }

    static class AstBuilderException
    extends ParserException {
        AstBuilderException(String message, Location location) {
            super(message, location);
        }
    }
}

