/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.Func;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.Token;
import io.cucumber.gherkin.TokenMatcher;
import io.cucumber.gherkin.TokenScanner;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

class Parser<T> {
    private final Builder<T> builder;

    Parser(Builder<T> builder) {
        this.builder = builder;
    }

    T parse(String source, String uri) {
        return this.parse(new StringReader(source), uri);
    }

    T parse(Reader source, String uri) {
        return this.parse(new TokenScanner(source), uri);
    }

    T parse(ITokenScanner tokenScanner, String uri) {
        return this.parse(tokenScanner, (ITokenMatcher)new TokenMatcher(), uri);
    }

    T parse(String source, ITokenMatcher tokenMatcher, String uri) {
        return this.parse(new StringReader(source), tokenMatcher, uri);
    }

    T parse(Reader source, ITokenMatcher tokenMatcher, String uri) {
        return this.parse(new TokenScanner(source), tokenMatcher, uri);
    }

    T parse(ITokenScanner tokenScanner, ITokenMatcher tokenMatcher, String uri) {
        Token token;
        this.builder.reset(uri);
        tokenMatcher.reset();
        ParserContext context = new ParserContext(tokenScanner, tokenMatcher, new LinkedList<Token>(), new ArrayList<ParserException>());
        this.startRule(context, RuleType.GherkinDocument);
        int state = 0;
        do {
            token = this.readToken(context);
            state = this.matchToken(state, token, context);
        } while (!token.isEOF());
        this.endRule(context, RuleType.GherkinDocument);
        if (context.errors.size() > 0) {
            throw new ParserException.CompositeParserException(context.errors);
        }
        return this.builder.getResult();
    }

    private void addError(ParserContext context, ParserException error) {
        String newErrorMessage = error.getMessage();
        for (ParserException e : context.errors) {
            if (!e.getMessage().equals(newErrorMessage)) continue;
            return;
        }
        context.errors.add(error);
        if (context.errors.size() > 10) {
            throw new ParserException.CompositeParserException(context.errors);
        }
    }

    private <V> V handleAstError(ParserContext context, Func<V> action) {
        return this.handleExternalError(context, action, null);
    }

    private <V> V handleExternalError(ParserContext context, Func<V> action, V defaultValue) {
        try {
            return action.call();
        }
        catch (ParserException.CompositeParserException compositeParserException) {
            for (ParserException error : compositeParserException.errors) {
                this.addError(context, error);
            }
        }
        catch (ParserException error) {
            this.addError(context, error);
        }
        return defaultValue;
    }

    private void build(ParserContext context, final Token token) {
        this.handleAstError(context, new Func<Void>(){

            @Override
            public Void call() {
                Parser.this.builder.build(token);
                return null;
            }
        });
    }

    private void startRule(ParserContext context, final RuleType ruleType) {
        this.handleAstError(context, new Func<Void>(){

            @Override
            public Void call() {
                Parser.this.builder.startRule(ruleType);
                return null;
            }
        });
    }

    private void endRule(ParserContext context, final RuleType ruleType) {
        this.handleAstError(context, new Func<Void>(){

            @Override
            public Void call() {
                Parser.this.builder.endRule(ruleType);
                return null;
            }
        });
    }

    private Token readToken(ParserContext context) {
        return context.tokenQueue.size() > 0 ? context.tokenQueue.remove() : context.tokenScanner.read();
    }

    private boolean match_EOF(final ParserContext context, final Token token) {
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_EOF(token);
            }
        }, false);
    }

    private boolean match_Empty(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_Empty(token);
            }
        }, false);
    }

    private boolean match_Comment(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_Comment(token);
            }
        }, false);
    }

    private boolean match_TagLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_TagLine(token);
            }
        }, false);
    }

    private boolean match_FeatureLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_FeatureLine(token);
            }
        }, false);
    }

    private boolean match_RuleLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_RuleLine(token);
            }
        }, false);
    }

    private boolean match_BackgroundLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_BackgroundLine(token);
            }
        }, false);
    }

    private boolean match_ScenarioLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_ScenarioLine(token);
            }
        }, false);
    }

    private boolean match_ExamplesLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_ExamplesLine(token);
            }
        }, false);
    }

    private boolean match_StepLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_StepLine(token);
            }
        }, false);
    }

    private boolean match_DocStringSeparator(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_DocStringSeparator(token);
            }
        }, false);
    }

    private boolean match_TableRow(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_TableRow(token);
            }
        }, false);
    }

    private boolean match_Language(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_Language(token);
            }
        }, false);
    }

    private boolean match_Other(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            @Override
            public Boolean call() {
                return context.tokenMatcher.match_Other(token);
            }
        }, false);
    }

    private int matchToken(int state, Token token, ParserContext context) {
        int newState;
        switch (state) {
            case 0: {
                newState = this.matchTokenAt_0(token, context);
                break;
            }
            case 1: {
                newState = this.matchTokenAt_1(token, context);
                break;
            }
            case 2: {
                newState = this.matchTokenAt_2(token, context);
                break;
            }
            case 3: {
                newState = this.matchTokenAt_3(token, context);
                break;
            }
            case 4: {
                newState = this.matchTokenAt_4(token, context);
                break;
            }
            case 5: {
                newState = this.matchTokenAt_5(token, context);
                break;
            }
            case 6: {
                newState = this.matchTokenAt_6(token, context);
                break;
            }
            case 7: {
                newState = this.matchTokenAt_7(token, context);
                break;
            }
            case 8: {
                newState = this.matchTokenAt_8(token, context);
                break;
            }
            case 9: {
                newState = this.matchTokenAt_9(token, context);
                break;
            }
            case 10: {
                newState = this.matchTokenAt_10(token, context);
                break;
            }
            case 11: {
                newState = this.matchTokenAt_11(token, context);
                break;
            }
            case 12: {
                newState = this.matchTokenAt_12(token, context);
                break;
            }
            case 13: {
                newState = this.matchTokenAt_13(token, context);
                break;
            }
            case 14: {
                newState = this.matchTokenAt_14(token, context);
                break;
            }
            case 15: {
                newState = this.matchTokenAt_15(token, context);
                break;
            }
            case 16: {
                newState = this.matchTokenAt_16(token, context);
                break;
            }
            case 17: {
                newState = this.matchTokenAt_17(token, context);
                break;
            }
            case 18: {
                newState = this.matchTokenAt_18(token, context);
                break;
            }
            case 19: {
                newState = this.matchTokenAt_19(token, context);
                break;
            }
            case 20: {
                newState = this.matchTokenAt_20(token, context);
                break;
            }
            case 21: {
                newState = this.matchTokenAt_21(token, context);
                break;
            }
            case 22: {
                newState = this.matchTokenAt_22(token, context);
                break;
            }
            case 23: {
                newState = this.matchTokenAt_23(token, context);
                break;
            }
            case 24: {
                newState = this.matchTokenAt_24(token, context);
                break;
            }
            case 25: {
                newState = this.matchTokenAt_25(token, context);
                break;
            }
            case 26: {
                newState = this.matchTokenAt_26(token, context);
                break;
            }
            case 27: {
                newState = this.matchTokenAt_27(token, context);
                break;
            }
            case 28: {
                newState = this.matchTokenAt_28(token, context);
                break;
            }
            case 29: {
                newState = this.matchTokenAt_29(token, context);
                break;
            }
            case 30: {
                newState = this.matchTokenAt_30(token, context);
                break;
            }
            case 31: {
                newState = this.matchTokenAt_31(token, context);
                break;
            }
            case 32: {
                newState = this.matchTokenAt_32(token, context);
                break;
            }
            case 33: {
                newState = this.matchTokenAt_33(token, context);
                break;
            }
            case 34: {
                newState = this.matchTokenAt_34(token, context);
                break;
            }
            case 35: {
                newState = this.matchTokenAt_35(token, context);
                break;
            }
            case 36: {
                newState = this.matchTokenAt_36(token, context);
                break;
            }
            case 37: {
                newState = this.matchTokenAt_37(token, context);
                break;
            }
            case 38: {
                newState = this.matchTokenAt_38(token, context);
                break;
            }
            case 39: {
                newState = this.matchTokenAt_39(token, context);
                break;
            }
            case 40: {
                newState = this.matchTokenAt_40(token, context);
                break;
            }
            case 41: {
                newState = this.matchTokenAt_41(token, context);
                break;
            }
            case 43: {
                newState = this.matchTokenAt_43(token, context);
                break;
            }
            case 44: {
                newState = this.matchTokenAt_44(token, context);
                break;
            }
            case 45: {
                newState = this.matchTokenAt_45(token, context);
                break;
            }
            case 46: {
                newState = this.matchTokenAt_46(token, context);
                break;
            }
            case 47: {
                newState = this.matchTokenAt_47(token, context);
                break;
            }
            case 48: {
                newState = this.matchTokenAt_48(token, context);
                break;
            }
            case 49: {
                newState = this.matchTokenAt_49(token, context);
                break;
            }
            case 50: {
                newState = this.matchTokenAt_50(token, context);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + state);
            }
        }
        return newState;
    }

    private int matchTokenAt_0(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.build(context, token);
            return 42;
        }
        if (this.match_Language(context, token)) {
            this.startRule(context, RuleType.Feature);
            this.startRule(context, RuleType.FeatureHeader);
            this.build(context, token);
            return 1;
        }
        if (this.match_TagLine(context, token)) {
            this.startRule(context, RuleType.Feature);
            this.startRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 2;
        }
        if (this.match_FeatureLine(context, token)) {
            this.startRule(context, RuleType.Feature);
            this.startRule(context, RuleType.FeatureHeader);
            this.build(context, token);
            return 3;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 0;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 0;
        }
        String stateComment = "State: 0 - Start";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Language", "#TagLine", "#FeatureLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 0 - Start") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 0 - Start");
        this.addError(context, error);
        return 0;
    }

    private int matchTokenAt_1(Token token, ParserContext context) {
        if (this.match_TagLine(context, token)) {
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 2;
        }
        if (this.match_FeatureLine(context, token)) {
            this.build(context, token);
            return 3;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 1;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 1;
        }
        String stateComment = "State: 1 - GherkinDocument:0>Feature:0>FeatureHeader:0>#Language:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#TagLine", "#FeatureLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 1 - GherkinDocument:0>Feature:0>FeatureHeader:0>#Language:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 1 - GherkinDocument:0>Feature:0>FeatureHeader:0>#Language:0");
        this.addError(context, error);
        return 1;
    }

    private int matchTokenAt_2(Token token, ParserContext context) {
        if (this.match_TagLine(context, token)) {
            this.build(context, token);
            return 2;
        }
        if (this.match_FeatureLine(context, token)) {
            this.endRule(context, RuleType.Tags);
            this.build(context, token);
            return 3;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 2;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 2;
        }
        String stateComment = "State: 2 - GherkinDocument:0>Feature:0>FeatureHeader:1>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#TagLine", "#FeatureLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 2 - GherkinDocument:0>Feature:0>FeatureHeader:1>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 2 - GherkinDocument:0>Feature:0>FeatureHeader:1>Tags:0>#TagLine:0");
        this.addError(context, error);
        return 2;
    }

    private int matchTokenAt_3(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 3;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 5;
        }
        if (this.match_BackgroundLine(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Background);
            this.build(context, token);
            return 6;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 4;
        }
        String stateComment = "State: 3 - GherkinDocument:0>Feature:0>FeatureHeader:2>#FeatureLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 3 - GherkinDocument:0>Feature:0>FeatureHeader:2>#FeatureLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 3 - GherkinDocument:0>Feature:0>FeatureHeader:2>#FeatureLine:0");
        this.addError(context, error);
        return 3;
    }

    private int matchTokenAt_4(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 5;
        }
        if (this.match_BackgroundLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Background);
            this.build(context, token);
            return 6;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 4;
        }
        String stateComment = "State: 4 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 4 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 4 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:1>Description:0>#Other:0");
        this.addError(context, error);
        return 4;
    }

    private int matchTokenAt_5(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 5;
        }
        if (this.match_BackgroundLine(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Background);
            this.build(context, token);
            return 6;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.FeatureHeader);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 5;
        }
        String stateComment = "State: 5 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 5 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 5 - GherkinDocument:0>Feature:0>FeatureHeader:3>DescriptionHelper:2>#Comment:0");
        this.addError(context, error);
        return 5;
    }

    private int matchTokenAt_6(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 6;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 8;
        }
        if (this.match_StepLine(context, token)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 9;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 7;
        }
        String stateComment = "State: 6 - GherkinDocument:0>Feature:1>Background:0>#BackgroundLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 6 - GherkinDocument:0>Feature:1>Background:0>#BackgroundLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 6 - GherkinDocument:0>Feature:1>Background:0>#BackgroundLine:0");
        this.addError(context, error);
        return 6;
    }

    private int matchTokenAt_7(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 8;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 9;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 7;
        }
        String stateComment = "State: 7 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 7 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 7 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:1>Description:0>#Other:0");
        this.addError(context, error);
        return 7;
    }

    private int matchTokenAt_8(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 8;
        }
        if (this.match_StepLine(context, token)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 9;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 8;
        }
        String stateComment = "State: 8 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 8 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 8 - GherkinDocument:0>Feature:1>Background:1>DescriptionHelper:2>#Comment:0");
        this.addError(context, error);
        return 8;
    }

    private int matchTokenAt_9(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_TableRow(context, token)) {
            this.startRule(context, RuleType.DataTable);
            this.build(context, token);
            return 10;
        }
        if (this.match_DocStringSeparator(context, token)) {
            this.startRule(context, RuleType.DocString);
            this.build(context, token);
            return 49;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 9;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 9;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 9;
        }
        String stateComment = "State: 9 - GherkinDocument:0>Feature:1>Background:2>Step:0>#StepLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 9 - GherkinDocument:0>Feature:1>Background:2>Step:0>#StepLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 9 - GherkinDocument:0>Feature:1>Background:2>Step:0>#StepLine:0");
        this.addError(context, error);
        return 9;
    }

    private int matchTokenAt_10(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_TableRow(context, token)) {
            this.build(context, token);
            return 10;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 9;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 10;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 10;
        }
        String stateComment = "State: 10 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 10 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 10 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0");
        this.addError(context, error);
        return 10;
    }

    private int matchTokenAt_11(Token token, ParserContext context) {
        if (this.match_TagLine(context, token)) {
            this.build(context, token);
            return 11;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Tags);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 11;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 11;
        }
        String stateComment = "State: 11 - GherkinDocument:0>Feature:2>ScenarioDefinition:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#TagLine", "#ScenarioLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 11 - GherkinDocument:0>Feature:2>ScenarioDefinition:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 11 - GherkinDocument:0>Feature:2>ScenarioDefinition:0>Tags:0>#TagLine:0");
        this.addError(context, error);
        return 11;
    }

    private int matchTokenAt_12(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 12;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 14;
        }
        if (this.match_StepLine(context, token)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 15;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 17;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 13;
        }
        String stateComment = "State: 12 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 12 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 12 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0");
        this.addError(context, error);
        return 12;
    }

    private int matchTokenAt_13(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 14;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 15;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 17;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 13;
        }
        String stateComment = "State: 13 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 13 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 13 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>#Other:0");
        this.addError(context, error);
        return 13;
    }

    private int matchTokenAt_14(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 14;
        }
        if (this.match_StepLine(context, token)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 15;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 17;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 14;
        }
        String stateComment = "State: 14 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 14 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 14 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:2>#Comment:0");
        this.addError(context, error);
        return 14;
    }

    private int matchTokenAt_15(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_TableRow(context, token)) {
            this.startRule(context, RuleType.DataTable);
            this.build(context, token);
            return 16;
        }
        if (this.match_DocStringSeparator(context, token)) {
            this.startRule(context, RuleType.DocString);
            this.build(context, token);
            return 47;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 15;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 17;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 15;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 15;
        }
        String stateComment = "State: 15 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 15 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 15 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0");
        this.addError(context, error);
        return 15;
    }

    private int matchTokenAt_16(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_TableRow(context, token)) {
            this.build(context, token);
            return 16;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 15;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 17;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 16;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 16;
        }
        String stateComment = "State: 16 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 16 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 16 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0");
        this.addError(context, error);
        return 16;
    }

    private int matchTokenAt_17(Token token, ParserContext context) {
        if (this.match_TagLine(context, token)) {
            this.build(context, token);
            return 17;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Tags);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 17;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 17;
        }
        String stateComment = "State: 17 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#TagLine", "#ExamplesLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 17 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 17 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0");
        this.addError(context, error);
        return 17;
    }

    private int matchTokenAt_18(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 18;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 20;
        }
        if (this.match_TableRow(context, token)) {
            this.startRule(context, RuleType.ExamplesTable);
            this.build(context, token);
            return 21;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 17;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 19;
        }
        String stateComment = "State: 18 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 18 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 18 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0");
        this.addError(context, error);
        return 18;
    }

    private int matchTokenAt_19(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 20;
        }
        if (this.match_TableRow(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesTable);
            this.build(context, token);
            return 21;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 17;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 19;
        }
        String stateComment = "State: 19 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 19 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 19 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>#Other:0");
        this.addError(context, error);
        return 19;
    }

    private int matchTokenAt_20(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 20;
        }
        if (this.match_TableRow(context, token)) {
            this.startRule(context, RuleType.ExamplesTable);
            this.build(context, token);
            return 21;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 17;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 20;
        }
        String stateComment = "State: 20 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 20 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 20 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:2>#Comment:0");
        this.addError(context, error);
        return 20;
    }

    private int matchTokenAt_21(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_TableRow(context, token)) {
            this.build(context, token);
            return 21;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 17;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 21;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 21;
        }
        String stateComment = "State: 21 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 21 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 21 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0");
        this.addError(context, error);
        return 21;
    }

    private int matchTokenAt_22(Token token, ParserContext context) {
        if (this.match_TagLine(context, token)) {
            this.build(context, token);
            return 22;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Tags);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 22;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 22;
        }
        String stateComment = "State: 22 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#TagLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 22 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 22 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:0>Tags:0>#TagLine:0");
        this.addError(context, error);
        return 22;
    }

    private int matchTokenAt_23(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 25;
        }
        if (this.match_BackgroundLine(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Background);
            this.build(context, token);
            return 26;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 24;
        }
        String stateComment = "State: 23 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:1>#RuleLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 23 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:1>#RuleLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 23 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:1>#RuleLine:0");
        this.addError(context, error);
        return 23;
    }

    private int matchTokenAt_24(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 25;
        }
        if (this.match_BackgroundLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Background);
            this.build(context, token);
            return 26;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 24;
        }
        String stateComment = "State: 24 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 24 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 24 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:1>Description:0>#Other:0");
        this.addError(context, error);
        return 24;
    }

    private int matchTokenAt_25(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 25;
        }
        if (this.match_BackgroundLine(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Background);
            this.build(context, token);
            return 26;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.RuleHeader);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 25;
        }
        String stateComment = "State: 25 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#BackgroundLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 25 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 25 - GherkinDocument:0>Feature:3>Rule:0>RuleHeader:2>DescriptionHelper:2>#Comment:0");
        this.addError(context, error);
        return 25;
    }

    private int matchTokenAt_26(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 26;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 28;
        }
        if (this.match_StepLine(context, token)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 29;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 27;
        }
        String stateComment = "State: 26 - GherkinDocument:0>Feature:3>Rule:1>Background:0>#BackgroundLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 26 - GherkinDocument:0>Feature:3>Rule:1>Background:0>#BackgroundLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 26 - GherkinDocument:0>Feature:3>Rule:1>Background:0>#BackgroundLine:0");
        this.addError(context, error);
        return 26;
    }

    private int matchTokenAt_27(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 28;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 29;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 27;
        }
        String stateComment = "State: 27 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 27 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 27 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:1>Description:0>#Other:0");
        this.addError(context, error);
        return 27;
    }

    private int matchTokenAt_28(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 28;
        }
        if (this.match_StepLine(context, token)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 29;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 28;
        }
        String stateComment = "State: 28 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 28 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 28 - GherkinDocument:0>Feature:3>Rule:1>Background:1>DescriptionHelper:2>#Comment:0");
        this.addError(context, error);
        return 28;
    }

    private int matchTokenAt_29(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_TableRow(context, token)) {
            this.startRule(context, RuleType.DataTable);
            this.build(context, token);
            return 30;
        }
        if (this.match_DocStringSeparator(context, token)) {
            this.startRule(context, RuleType.DocString);
            this.build(context, token);
            return 45;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 29;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 29;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 29;
        }
        String stateComment = "State: 29 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:0>#StepLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 29 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:0>#StepLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 29 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:0>#StepLine:0");
        this.addError(context, error);
        return 29;
    }

    private int matchTokenAt_30(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_TableRow(context, token)) {
            this.build(context, token);
            return 30;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 29;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 30;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 30;
        }
        String stateComment = "State: 30 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 30 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 30 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0");
        this.addError(context, error);
        return 30;
    }

    private int matchTokenAt_31(Token token, ParserContext context) {
        if (this.match_TagLine(context, token)) {
            this.build(context, token);
            return 31;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Tags);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 31;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 31;
        }
        String stateComment = "State: 31 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#TagLine", "#ScenarioLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 31 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 31 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:0>Tags:0>#TagLine:0");
        this.addError(context, error);
        return 31;
    }

    private int matchTokenAt_32(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 32;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 34;
        }
        if (this.match_StepLine(context, token)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 37;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 33;
        }
        String stateComment = "State: 32 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 32 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 32 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:0>#ScenarioLine:0");
        this.addError(context, error);
        return 32;
    }

    private int matchTokenAt_33(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 34;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 37;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 33;
        }
        String stateComment = "State: 33 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 33 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 33 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:1>Description:0>#Other:0");
        this.addError(context, error);
        return 33;
    }

    private int matchTokenAt_34(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 34;
        }
        if (this.match_StepLine(context, token)) {
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 37;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 34;
        }
        String stateComment = "State: 34 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 34 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 34 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:1>DescriptionHelper:2>#Comment:0");
        this.addError(context, error);
        return 34;
    }

    private int matchTokenAt_35(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_TableRow(context, token)) {
            this.startRule(context, RuleType.DataTable);
            this.build(context, token);
            return 36;
        }
        if (this.match_DocStringSeparator(context, token)) {
            this.startRule(context, RuleType.DocString);
            this.build(context, token);
            return 43;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 37;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 35;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 35;
        }
        String stateComment = "State: 35 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 35 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 35 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:0>#StepLine:0");
        this.addError(context, error);
        return 35;
    }

    private int matchTokenAt_36(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_TableRow(context, token)) {
            this.build(context, token);
            return 36;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 37;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 36;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 36;
        }
        String stateComment = "State: 36 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 36 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 36 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:0>DataTable:0>#TableRow:0");
        this.addError(context, error);
        return 36;
    }

    private int matchTokenAt_37(Token token, ParserContext context) {
        if (this.match_TagLine(context, token)) {
            this.build(context, token);
            return 37;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Tags);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 37;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 37;
        }
        String stateComment = "State: 37 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#TagLine", "#ExamplesLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 37 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 37 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:0>Tags:0>#TagLine:0");
        this.addError(context, error);
        return 37;
    }

    private int matchTokenAt_38(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 38;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 40;
        }
        if (this.match_TableRow(context, token)) {
            this.startRule(context, RuleType.ExamplesTable);
            this.build(context, token);
            return 41;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 37;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 39;
        }
        String stateComment = "State: 38 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 38 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 38 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:0>#ExamplesLine:0");
        this.addError(context, error);
        return 38;
    }

    private int matchTokenAt_39(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 40;
        }
        if (this.match_TableRow(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.ExamplesTable);
            this.build(context, token);
            return 41;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 37;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 39;
        }
        String stateComment = "State: 39 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 39 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 39 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:1>Description:0>#Other:0");
        this.addError(context, error);
        return 39;
    }

    private int matchTokenAt_40(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 40;
        }
        if (this.match_TableRow(context, token)) {
            this.startRule(context, RuleType.ExamplesTable);
            this.build(context, token);
            return 41;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 37;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 40;
        }
        String stateComment = "State: 40 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 40 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 40 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:1>DescriptionHelper:2>#Comment:0");
        this.addError(context, error);
        return 40;
    }

    private int matchTokenAt_41(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_TableRow(context, token)) {
            this.build(context, token);
            return 41;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 37;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.ExamplesTable);
            this.endRule(context, RuleType.Examples);
            this.endRule(context, RuleType.ExamplesDefinition);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 41;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 41;
        }
        String stateComment = "State: 41 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 41 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 41 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:3>ExamplesDefinition:1>Examples:2>ExamplesTable:0>#TableRow:0");
        this.addError(context, error);
        return 41;
    }

    private int matchTokenAt_43(Token token, ParserContext context) {
        if (this.match_DocStringSeparator(context, token)) {
            this.build(context, token);
            return 44;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 43;
        }
        String stateComment = "State: 43 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#DocStringSeparator", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 43 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 43 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0");
        this.addError(context, error);
        return 43;
    }

    private int matchTokenAt_44(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 37;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 38;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 44;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 44;
        }
        String stateComment = "State: 44 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 44 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 44 - GherkinDocument:0>Feature:3>Rule:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0");
        this.addError(context, error);
        return 44;
    }

    private int matchTokenAt_45(Token token, ParserContext context) {
        if (this.match_DocStringSeparator(context, token)) {
            this.build(context, token);
            return 46;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 45;
        }
        String stateComment = "State: 45 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#DocStringSeparator", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 45 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 45 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0");
        this.addError(context, error);
        return 45;
    }

    private int matchTokenAt_46(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 29;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 31;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 32;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Rule);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 46;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 46;
        }
        String stateComment = "State: 46 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 46 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 46 - GherkinDocument:0>Feature:3>Rule:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0");
        this.addError(context, error);
        return 46;
    }

    private int matchTokenAt_47(Token token, ParserContext context) {
        if (this.match_DocStringSeparator(context, token)) {
            this.build(context, token);
            return 48;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 47;
        }
        String stateComment = "State: 47 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#DocStringSeparator", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 47 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 47 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0");
        this.addError(context, error);
        return 47;
    }

    private int matchTokenAt_48(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 15;
        }
        if (this.match_TagLine(context, token) && this.lookahead_1(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 17;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ExamplesLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.ExamplesDefinition);
            this.startRule(context, RuleType.Examples);
            this.build(context, token);
            return 18;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Scenario);
            this.endRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 48;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 48;
        }
        String stateComment = "State: 48 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#StepLine", "#TagLine", "#ExamplesLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 48 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 48 - GherkinDocument:0>Feature:2>ScenarioDefinition:1>Scenario:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0");
        this.addError(context, error);
        return 48;
    }

    private int matchTokenAt_49(Token token, ParserContext context) {
        if (this.match_DocStringSeparator(context, token)) {
            this.build(context, token);
            return 50;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 49;
        }
        String stateComment = "State: 49 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#DocStringSeparator", "#Other");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 49 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 49 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:0>#DocStringSeparator:0");
        this.addError(context, error);
        return 49;
    }

    private int matchTokenAt_50(Token token, ParserContext context) {
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.endRule(context, RuleType.Feature);
            this.build(context, token);
            return 42;
        }
        if (this.match_StepLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.startRule(context, RuleType.Step);
            this.build(context, token);
            return 9;
        }
        if (this.match_TagLine(context, token) && this.lookahead_0(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 11;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 22;
        }
        if (this.match_ScenarioLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.ScenarioDefinition);
            this.startRule(context, RuleType.Scenario);
            this.build(context, token);
            return 12;
        }
        if (this.match_RuleLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Step);
            this.endRule(context, RuleType.Background);
            this.startRule(context, RuleType.Rule);
            this.startRule(context, RuleType.RuleHeader);
            this.build(context, token);
            return 23;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 50;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 50;
        }
        String stateComment = "State: 50 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#StepLine", "#TagLine", "#ScenarioLine", "#RuleLine", "#Comment", "#Empty");
        ParserException error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 50 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 50 - GherkinDocument:0>Feature:1>Background:2>Step:1>StepArg:0>__alt0:1>DocString:2>#DocStringSeparator:0");
        this.addError(context, error);
        return 50;
    }

    private boolean lookahead_0(ParserContext context, Token currentToken) {
        Token token;
        currentToken.detach();
        ArrayDeque<Token> queue = new ArrayDeque<Token>();
        boolean match = false;
        do {
            token = this.readToken(context);
            token.detach();
            queue.add(token);
            if (!this.match_ScenarioLine(context, token)) continue;
            match = true;
            break;
        } while (this.match_Empty(context, token) || this.match_Comment(context, token) || this.match_TagLine(context, token));
        context.tokenQueue.addAll(queue);
        return match;
    }

    private boolean lookahead_1(ParserContext context, Token currentToken) {
        Token token;
        currentToken.detach();
        ArrayDeque<Token> queue = new ArrayDeque<Token>();
        boolean match = false;
        do {
            token = this.readToken(context);
            token.detach();
            queue.add(token);
            if (!this.match_ExamplesLine(context, token)) continue;
            match = true;
            break;
        } while (this.match_Empty(context, token) || this.match_Comment(context, token) || this.match_TagLine(context, token));
        context.tokenQueue.addAll(queue);
        return match;
    }

    static interface ITokenMatcher {
        public boolean match_EOF(Token var1);

        public boolean match_Empty(Token var1);

        public boolean match_Comment(Token var1);

        public boolean match_TagLine(Token var1);

        public boolean match_FeatureLine(Token var1);

        public boolean match_RuleLine(Token var1);

        public boolean match_BackgroundLine(Token var1);

        public boolean match_ScenarioLine(Token var1);

        public boolean match_ExamplesLine(Token var1);

        public boolean match_StepLine(Token var1);

        public boolean match_DocStringSeparator(Token var1);

        public boolean match_TableRow(Token var1);

        public boolean match_Language(Token var1);

        public boolean match_Other(Token var1);

        public void reset();
    }

    static interface ITokenScanner {
        public Token read();
    }

    static interface Builder<T> {
        public void build(Token var1);

        public void startRule(RuleType var1);

        public void endRule(RuleType var1);

        public T getResult();

        public void reset(String var1);
    }

    static class ParserContext {
        final ITokenScanner tokenScanner;
        final ITokenMatcher tokenMatcher;
        final Queue<Token> tokenQueue;
        final List<ParserException> errors;

        ParserContext(ITokenScanner tokenScanner, ITokenMatcher tokenMatcher, Queue<Token> tokenQueue, List<ParserException> errors) {
            this.tokenScanner = tokenScanner;
            this.tokenMatcher = tokenMatcher;
            this.tokenQueue = tokenQueue;
            this.errors = errors;
        }
    }

    static enum RuleType {
        None,
        _EOF,
        _Empty,
        _Comment,
        _TagLine,
        _FeatureLine,
        _RuleLine,
        _BackgroundLine,
        _ScenarioLine,
        _ExamplesLine,
        _StepLine,
        _DocStringSeparator,
        _TableRow,
        _Language,
        _Other,
        GherkinDocument,
        Feature,
        FeatureHeader,
        Rule,
        RuleHeader,
        Background,
        ScenarioDefinition,
        Scenario,
        ExamplesDefinition,
        Examples,
        ExamplesTable,
        Step,
        StepArg,
        DataTable,
        DocString,
        Tags,
        DescriptionHelper,
        Description;


        static RuleType cast(TokenType tokenType) {
            return RuleType.values()[tokenType.ordinal()];
        }
    }

    static enum TokenType {
        None,
        EOF,
        Empty,
        Comment,
        TagLine,
        FeatureLine,
        RuleLine,
        BackgroundLine,
        ScenarioLine,
        ExamplesLine,
        StepLine,
        DocStringSeparator,
        TableRow,
        Language,
        Other;

    }
}

