/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.messages.types.StepKeywordType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GherkinDialect {
    private final String language;
    private final String name;
    private final String nativeName;
    private final List<String> featureKeywords;
    private final List<String> ruleKeywords;
    private final List<String> scenarioKeywords;
    private final List<String> scenarioOutlineKeywords;
    private final List<String> backgroundKeywords;
    private final List<String> examplesKeywords;
    private final List<String> givenKeywords;
    private final List<String> whenKeywords;
    private final List<String> thenKeywords;
    private final List<String> andKeywords;
    private final List<String> butKeywords;
    private final List<String> stepKeywords;
    private final Map<String, List<StepKeywordType>> stepKeywordsTypes;

    GherkinDialect(String language, String name, String nativeName, List<String> featureKeywords, List<String> ruleKeywords, List<String> scenarioKeywords, List<String> scenarioOutlineKeywords, List<String> backgroundKeywords, List<String> examplesKeywords, List<String> givenKeywords, List<String> whenKeywords, List<String> thenKeywords, List<String> andKeywords, List<String> butKeywords) {
        this.language = language;
        this.name = name;
        this.nativeName = nativeName;
        this.featureKeywords = featureKeywords;
        this.ruleKeywords = ruleKeywords;
        this.scenarioKeywords = scenarioKeywords;
        this.scenarioOutlineKeywords = scenarioOutlineKeywords;
        this.backgroundKeywords = backgroundKeywords;
        this.examplesKeywords = examplesKeywords;
        this.givenKeywords = givenKeywords;
        this.whenKeywords = whenKeywords;
        this.thenKeywords = thenKeywords;
        this.andKeywords = andKeywords;
        this.butKeywords = butKeywords;
        ArrayList<String> stepKeywords = new ArrayList<String>();
        stepKeywords.addAll(givenKeywords);
        stepKeywords.addAll(whenKeywords);
        stepKeywords.addAll(thenKeywords);
        stepKeywords.addAll(andKeywords);
        stepKeywords.addAll(butKeywords);
        this.stepKeywords = Collections.unmodifiableList(stepKeywords);
        HashMap<String, List<StepKeywordType>> stepKeywordsTypes = new HashMap<String, List<StepKeywordType>>();
        GherkinDialect.addStepKeywordsTypes(stepKeywordsTypes, this.getGivenKeywords(), StepKeywordType.CONTEXT);
        GherkinDialect.addStepKeywordsTypes(stepKeywordsTypes, this.getWhenKeywords(), StepKeywordType.ACTION);
        GherkinDialect.addStepKeywordsTypes(stepKeywordsTypes, this.getThenKeywords(), StepKeywordType.OUTCOME);
        ArrayList<String> conjunctionKeywords = new ArrayList<String>();
        conjunctionKeywords.addAll(this.getAndKeywords());
        conjunctionKeywords.addAll(this.getButKeywords());
        GherkinDialect.addStepKeywordsTypes(stepKeywordsTypes, conjunctionKeywords, StepKeywordType.CONJUNCTION);
        this.stepKeywordsTypes = stepKeywordsTypes;
    }

    private static void addStepKeywordsTypes(Map<String, List<StepKeywordType>> h, List<String> keywords, StepKeywordType type) {
        for (String keyword : keywords) {
            if (!h.containsKey(keyword)) {
                h.put(keyword, new ArrayList());
            }
            h.get(keyword).add(type);
        }
    }

    public List<String> getFeatureKeywords() {
        return this.featureKeywords;
    }

    public String getName() {
        return this.name;
    }

    public String getNativeName() {
        return this.nativeName;
    }

    public List<String> getRuleKeywords() {
        return this.ruleKeywords;
    }

    public List<String> getScenarioKeywords() {
        return this.scenarioKeywords;
    }

    public List<String> getScenarioOutlineKeywords() {
        return this.scenarioOutlineKeywords;
    }

    public List<String> getStepKeywords() {
        return this.stepKeywords;
    }

    public List<StepKeywordType> getStepKeywordTypes(String keyword) {
        return this.stepKeywordsTypes.get(keyword);
    }

    public List<String> getBackgroundKeywords() {
        return this.backgroundKeywords;
    }

    public List<String> getExamplesKeywords() {
        return this.examplesKeywords;
    }

    public List<String> getGivenKeywords() {
        return this.givenKeywords;
    }

    public List<String> getWhenKeywords() {
        return this.whenKeywords;
    }

    public List<String> getThenKeywords() {
        return this.thenKeywords;
    }

    public List<String> getAndKeywords() {
        return this.andKeywords;
    }

    public List<String> getButKeywords() {
        return this.butKeywords;
    }

    public String getLanguage() {
        return this.language;
    }
}

