/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.GherkinDocumentBuilder;
import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.PickleCompiler;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.ParseError;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.SourceReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GherkinParser {
    private final boolean includeSource;
    private final boolean includeGherkinDocument;
    private final boolean includePickles;
    private final IdGenerator idGenerator;
    private final PickleCompiler pickleCompiler;

    private GherkinParser(boolean includeSource, boolean includeGherkinDocument, boolean includePickles, IdGenerator idGenerator) {
        this.includeSource = includeSource;
        this.includeGherkinDocument = includeGherkinDocument;
        this.includePickles = includePickles;
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.pickleCompiler = new PickleCompiler(idGenerator);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Stream<Envelope> parse(Envelope envelope) {
        Objects.requireNonNull(envelope);
        ArrayList<Envelope> messages = new ArrayList<Envelope>();
        if (this.includeSource) {
            messages.add(envelope);
        }
        envelope.getSource().map(this::parse).ifPresent(messages::addAll);
        return messages.stream();
    }

    private List<Envelope> parse(Source source) {
        return this.parse(source.getUri(), source.getData());
    }

    private List<Envelope> parse(String uri, String data) {
        ArrayList<Envelope> messages = new ArrayList<Envelope>();
        GherkinDocumentBuilder documentBuilder = new GherkinDocumentBuilder(this.idGenerator, uri);
        Parser<GherkinDocument> parser = new Parser<GherkinDocument>(documentBuilder);
        try {
            GherkinDocument gherkinDocument = parser.parse(data, uri);
            if (this.includeGherkinDocument) {
                messages.add(Envelope.of((GherkinDocument)gherkinDocument));
            }
            if (this.includePickles) {
                this.pickleCompiler.compile(gherkinDocument, uri).stream().map(Envelope::of).collect(Collectors.toCollection(() -> messages));
            }
        }
        catch (ParserException.CompositeParserException composite) {
            composite.errors.stream().map(error -> this.createParseError((ParserException)error, uri)).collect(Collectors.toCollection(() -> messages));
        }
        catch (ParserException error2) {
            messages.add(this.createParseError(error2, uri));
        }
        return messages;
    }

    private Envelope createParseError(ParserException e, String uri) {
        long line = e.location.getLine();
        long column = e.location.getColumn();
        return Envelope.of((ParseError)new ParseError(new SourceReference(uri, null, null, new Location(Long.valueOf(line), column == 0L ? null : Long.valueOf(column))), e.getMessage()));
    }

    public static final class Builder {
        private boolean includeSource = true;
        private boolean includeGherkinDocument = true;
        private boolean includePickles = true;
        private IdGenerator idGenerator = () -> UUID.randomUUID().toString();

        private Builder() {
        }

        public Builder includeSource(boolean includeSource) {
            this.includeSource = includeSource;
            return this;
        }

        public Builder includeGherkinDocument(boolean includeGherkinDocument) {
            this.includeGherkinDocument = includeGherkinDocument;
            return this;
        }

        public Builder includePickles(boolean includePickles) {
            this.includePickles = includePickles;
            return this;
        }

        public Builder idGenerator(IdGenerator idGenerator) {
            this.idGenerator = Objects.requireNonNull(idGenerator);
            return this;
        }

        public GherkinParser build() {
            return new GherkinParser(this.includeSource, this.includeGherkinDocument, this.includePickles, this.idGenerator);
        }
    }
}

