/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.DataTableCellByTypeTransformer;
import io.cucumber.datatable.DataTableType;
import io.cucumber.datatable.DuplicateTypeException;
import io.cucumber.datatable.NumberParser;
import io.cucumber.datatable.TableCellByTypeTransformer;
import io.cucumber.datatable.TableCellTransformer;
import io.cucumber.datatable.TableEntryByTypeTransformer;
import io.cucumber.datatable.TypeFactory;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DataTableTypeRegistry {
    private final DataTableCellByTypeTransformer tableCellByTypeTransformer = new DataTableCellByTypeTransformer(this);
    private final Map<TypeFactory.JavaType, DataTableType> tableTypeByType = new HashMap<TypeFactory.JavaType, DataTableType>();
    private TableEntryByTypeTransformer defaultDataTableEntryTransformer;
    private TableCellByTypeTransformer defaultDataTableCellTransformer;

    public DataTableTypeRegistry(Locale locale) {
        NumberParser numberParser = new NumberParser(locale);
        TableCellTransformer<Object> objectTableCellTransformer = DataTableTypeRegistry.applyIfPresent(s -> s);
        this.defineDataTableType(new DataTableType((Type)((Object)Object.class), objectTableCellTransformer));
        TableCellTransformer<BigInteger> bigIntegerTableCellTransformer = DataTableTypeRegistry.applyIfPresent(BigInteger::new);
        this.defineDataTableType(new DataTableType((Type)((Object)BigInteger.class), bigIntegerTableCellTransformer));
        TableCellTransformer<BigDecimal> bigDecimalTableCellTransformer = DataTableTypeRegistry.applyIfPresent(numberParser::parseBigDecimal);
        this.defineDataTableType(new DataTableType((Type)((Object)BigDecimal.class), bigDecimalTableCellTransformer));
        TableCellTransformer<Byte> byteTableCellTransformer = DataTableTypeRegistry.applyIfPresent(Byte::decode);
        this.defineDataTableType(new DataTableType((Type)((Object)Byte.class), byteTableCellTransformer));
        this.defineDataTableType(new DataTableType(Byte.TYPE, byteTableCellTransformer));
        TableCellTransformer<Short> shortTableCellTransformer = DataTableTypeRegistry.applyIfPresent(Short::decode);
        this.defineDataTableType(new DataTableType((Type)((Object)Short.class), shortTableCellTransformer));
        this.defineDataTableType(new DataTableType(Short.TYPE, shortTableCellTransformer));
        TableCellTransformer<Integer> integerTableCellTransformer = DataTableTypeRegistry.applyIfPresent(Integer::decode);
        this.defineDataTableType(new DataTableType((Type)((Object)Integer.class), integerTableCellTransformer));
        this.defineDataTableType(new DataTableType(Integer.TYPE, integerTableCellTransformer));
        TableCellTransformer<Long> longTableCellTransformer = DataTableTypeRegistry.applyIfPresent(Long::decode);
        this.defineDataTableType(new DataTableType((Type)((Object)Long.class), longTableCellTransformer));
        this.defineDataTableType(new DataTableType(Long.TYPE, longTableCellTransformer));
        TableCellTransformer<Float> floatTableCellTransformer = DataTableTypeRegistry.applyIfPresent(numberParser::parseFloat);
        this.defineDataTableType(new DataTableType((Type)((Object)Float.class), floatTableCellTransformer));
        this.defineDataTableType(new DataTableType(Float.TYPE, floatTableCellTransformer));
        TableCellTransformer<Double> doubleTableCellTransformer = DataTableTypeRegistry.applyIfPresent(numberParser::parseDouble);
        this.defineDataTableType(new DataTableType((Type)((Object)Double.class), doubleTableCellTransformer));
        this.defineDataTableType(new DataTableType(Double.TYPE, doubleTableCellTransformer));
        TableCellTransformer<String> stringTableCellTransformer = cell -> cell;
        this.defineDataTableType(new DataTableType((Type)((Object)String.class), stringTableCellTransformer));
    }

    private static <R> TableCellTransformer<R> applyIfPresent(Function<String, R> f) {
        return s -> s == null ? null : f.apply(s);
    }

    public void defineDataTableType(DataTableType dataTableType) {
        DataTableType existing = this.tableTypeByType.get(dataTableType.getTargetType());
        if (existing != null) {
            throw new DuplicateTypeException(String.format("There already is a data table type registered that can supply %s.\nYou are trying to register a %s for %s.\nThe existing data table type registered a %s for %s.\n", dataTableType.getElementType(), dataTableType.getTransformerType().getSimpleName(), dataTableType.getElementType(), existing.getTransformerType().getSimpleName(), existing.getElementType()));
        }
        this.tableTypeByType.put(dataTableType.getTargetType(), dataTableType);
    }

    DataTableType lookupTableTypeByType(Type tableType) {
        TypeFactory.JavaType targetType = TypeFactory.constructType(tableType);
        return this.tableTypeByType.get(targetType);
    }

    DataTableType getDefaultTableCellTransformer(Type tableType) {
        if (this.defaultDataTableCellTransformer == null) {
            return null;
        }
        if (tableType instanceof TypeFactory.JavaType) {
            TypeFactory.JavaType javaType = (TypeFactory.JavaType)tableType;
            tableType = javaType.getOriginal();
        }
        return DataTableType.defaultCell(tableType, this.defaultDataTableCellTransformer);
    }

    DataTableType getDefaultTableEntryTransformer(Type tableType) {
        if (this.defaultDataTableEntryTransformer == null) {
            return null;
        }
        if (tableType instanceof TypeFactory.JavaType) {
            TypeFactory.JavaType javaType = (TypeFactory.JavaType)tableType;
            tableType = javaType.getOriginal();
        }
        return DataTableType.defaultEntry(tableType, this.defaultDataTableEntryTransformer, this.tableCellByTypeTransformer);
    }

    public void setDefaultDataTableEntryTransformer(TableEntryByTypeTransformer defaultDataTableEntryTransformer) {
        this.defaultDataTableEntryTransformer = defaultDataTableEntryTransformer;
    }

    public void setDefaultDataTableCellTransformer(TableCellByTypeTransformer defaultDataTableCellTransformer) {
        this.defaultDataTableCellTransformer = defaultDataTableCellTransformer;
    }
}

