/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.spring;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.spring.CucumberContextConfiguration;
import io.cucumber.spring.TestContextAdaptor;
import java.util.Collection;
import java.util.HashSet;
import org.apiguardian.api.API;
import org.springframework.beans.BeansException;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import org.springframework.test.context.TestContextManager;

@API(status=API.Status.STABLE)
public final class SpringFactory
implements ObjectFactory {
    private final Collection<Class<?>> stepClasses = new HashSet();
    private Class<?> withCucumberContextConfiguration = null;
    private TestContextAdaptor testContextAdaptor;

    public boolean addClass(Class<?> stepClass) {
        if (this.stepClasses.contains(stepClass)) {
            return true;
        }
        SpringFactory.checkNoComponentAnnotations(stepClass);
        if (SpringFactory.hasCucumberContextConfiguration(stepClass)) {
            this.checkOnlyOneClassHasCucumberContextConfiguration(stepClass);
            this.withCucumberContextConfiguration = stepClass;
        }
        this.stepClasses.add(stepClass);
        return true;
    }

    private static void checkNoComponentAnnotations(Class<?> type) {
        if (AnnotatedElementUtils.isAnnotated(type, Component.class)) {
            throw new CucumberBackendException(String.format("Glue class %1$s was (meta-)annotated with @Component; marking it as a candidate for auto-detection by Spring. Glue classes are detected and registered by Cucumber. Auto-detection of glue classes by spring may lead to duplicate bean definitions. Please remove the @Component (meta-)annotation", type.getName()));
        }
    }

    static boolean hasCucumberContextConfiguration(Class<?> stepClass) {
        return AnnotatedElementUtils.isAnnotated(stepClass, CucumberContextConfiguration.class);
    }

    private void checkOnlyOneClassHasCucumberContextConfiguration(Class<?> stepClass) {
        if (this.withCucumberContextConfiguration != null) {
            throw new CucumberBackendException(String.format("Glue class %1$s and %2$s are both (meta-)annotated with @CucumberContextConfiguration.\nPlease ensure only one class configures the spring context\n\nBy default Cucumber scans the entire classpath for context configuration.\nYou can restrict this by configuring the glue path.\n" + ClasspathSupport.configurationExamples(), stepClass, this.withCucumberContextConfiguration));
        }
    }

    public void start() {
        if (this.withCucumberContextConfiguration == null) {
            throw new CucumberBackendException("Please annotate a glue class with some context configuration.\n\nFor example:\n\n   @CucumberContextConfiguration\n   @SpringBootTest(classes = TestConfig.class)\n   public class CucumberSpringConfiguration { }\nOr: \n\n   @CucumberContextConfiguration\n   @ContextConfiguration( ... )\n   public class CucumberSpringConfiguration { }");
        }
        TestContextManager testContextManager = new TestContextManager(this.withCucumberContextConfiguration);
        this.testContextAdaptor = new TestContextAdaptor(testContextManager, this.stepClasses);
        this.testContextAdaptor.start();
    }

    public void stop() {
        if (this.testContextAdaptor != null) {
            this.testContextAdaptor.stop();
        }
    }

    public <T> T getInstance(Class<T> type) {
        try {
            return this.testContextAdaptor.getInstance(type);
        }
        catch (BeansException e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }
}

