/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.plugin.event;

import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class Location
implements Comparable<Location> {
    private final int line;
    private final int column;

    public Location(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.line == location.line && this.column == location.column;
    }

    @Override
    public int compareTo(Location o) {
        Objects.requireNonNull(o);
        int c = Integer.compare(this.line, o.line);
        if (c != 0) {
            return c;
        }
        return Integer.compare(this.column, o.column);
    }
}

