/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.plugin.event;

import io.cucumber.plugin.event.Location;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public interface Node {
    public Location getLocation();

    public Optional<String> getKeyword();

    public Optional<String> getName();

    public Optional<Node> getParent();

    default public <T> T map(T parent, BiFunction<Feature, T, T> mapFeature, BiFunction<Rule, T, T> mapRule, BiFunction<Scenario, T, T> mapScenario, BiFunction<ScenarioOutline, T, T> mapScenarioOutline, BiFunction<Examples, T, T> mapExamples, BiFunction<Example, T, T> mapExample) {
        if (this instanceof Scenario) {
            return mapScenario.apply((Scenario)this, (Scenario)parent);
        }
        if (this instanceof Example) {
            return mapExample.apply((Example)this, (Example)parent);
        }
        if (this instanceof Container) {
            Object mapped;
            if (this instanceof Feature) {
                mapped = mapFeature.apply((Feature)this, (Feature)parent);
            } else if (this instanceof Rule) {
                mapped = mapRule.apply((Rule)this, (Rule)parent);
            } else if (this instanceof ScenarioOutline) {
                mapped = mapScenarioOutline.apply((ScenarioOutline)this, (ScenarioOutline)parent);
            } else if (this instanceof Examples) {
                mapped = mapExamples.apply((Examples)this, (Examples)parent);
            } else {
                throw new IllegalArgumentException(this.getClass().getName());
            }
            Container container = (Container)this;
            container.elements().forEach(node -> node.map(mapped, mapFeature, mapRule, mapScenario, mapScenarioOutline, mapExamples, mapExample));
            return mapped;
        }
        throw new IllegalArgumentException(this.getClass().getName());
    }

    default public Optional<List<Node>> findPathTo(Predicate<Node> predicate) {
        if (predicate.test(this)) {
            ArrayList<Node> path = new ArrayList<Node>();
            path.add(this);
            return Optional.of(path);
        }
        return Optional.empty();
    }

    public static interface Scenario
    extends Node {
    }

    public static interface Example
    extends Node {
    }

    public static interface Container<T extends Node>
    extends Node {
        @Override
        default public Optional<List<Node>> findPathTo(Predicate<Node> predicate) {
            ArrayList<Node> path = new ArrayList<Node>();
            ArrayDeque<ArrayDeque<Container<T>>> toSearch = new ArrayDeque<ArrayDeque<Container<T>>>();
            toSearch.addLast(new ArrayDeque<Container>(Collections.singletonList(this)));
            while (!toSearch.isEmpty()) {
                Deque candidates = (Deque)toSearch.peekLast();
                if (candidates.isEmpty()) {
                    if (!path.isEmpty()) {
                        path.remove(path.size() - 1);
                    }
                    toSearch.removeLast();
                    continue;
                }
                Node candidate = (Node)candidates.pop();
                if (predicate.test(candidate)) {
                    path.add(candidate);
                    return Optional.of(path);
                }
                if (!(candidate instanceof Container)) continue;
                path.add(candidate);
                Container container = (Container)candidate;
                toSearch.addLast(new ArrayDeque<T>(container.elements()));
            }
            return Optional.empty();
        }

        public Collection<T> elements();
    }

    public static interface Feature
    extends Node,
    Container<Node> {
    }

    public static interface Rule
    extends Node,
    Container<Node> {
    }

    public static interface ScenarioOutline
    extends Node,
    Container<Examples> {
    }

    public static interface Examples
    extends Node,
    Container<Example> {
    }
}

