/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.plugin.event;

import io.cucumber.plugin.event.Status;
import java.time.Duration;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class Result {
    private final Status status;
    private final Duration duration;
    private final Throwable error;

    public Result(Status status, Duration duration, Throwable error) {
        this.status = Objects.requireNonNull(status);
        this.duration = Objects.requireNonNull(duration);
        this.error = error;
    }

    public Status getStatus() {
        return this.status;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Throwable getError() {
        return this.error;
    }

    public String toString() {
        return "Result{status=" + (Object)((Object)this.status) + ", duration=" + this.duration.getSeconds() + ", error=" + this.error + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return this.status == result.status && Objects.equals(this.duration, result.duration) && Objects.equals(this.error, result.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.duration, this.error});
    }
}

