/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.junit.platform.engine.CucumberDiscoverySelectors;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;

final class FeatureWithLinesFileResolver
implements SelectorResolver {
    FeatureWithLinesFileResolver() {
    }

    static boolean isTxtFile(Path path) {
        return path.getFileName().toString().endsWith(".txt");
    }

    public SelectorResolver.Resolution resolve(FileSelector selector, SelectorResolver.Context context) {
        Path path = selector.getPath();
        if (!FeatureWithLinesFileResolver.isTxtFile(path)) {
            return SelectorResolver.Resolution.unresolved();
        }
        Set selectors = FeatureWithLines.parseFile((Path)path).stream().map(CucumberDiscoverySelectors.FeatureWithLinesSelector::from).collect(Collectors.toSet());
        return SelectorResolver.Resolution.selectors(selectors);
    }
}

