/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import java.net.URI;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.UriSource;

abstract class FeatureSource {
    FeatureSource() {
    }

    private static FilePosition createFilePosition(Location location) {
        return FilePosition.from((int)location.getLine(), (int)location.getColumn());
    }

    static FeatureSource of(URI uri) {
        if ("classpath".equals(uri.getScheme())) {
            if (!uri.getSchemeSpecificPart().startsWith("/")) {
                uri = URI.create("classpath:/" + uri.getRawSchemeSpecificPart());
            }
            ClasspathResourceSource source = ClasspathResourceSource.from((URI)uri);
            return new FeatureClasspathSource(source);
        }
        UriSource source = UriSource.from((URI)uri);
        if (source instanceof FileSource) {
            return new FeatureFileSource((FileSource)source);
        }
        return new FeatureUriSource(source);
    }

    abstract TestSource nodeSource(Node var1);

    abstract TestSource source();

    private static class FeatureClasspathSource
    extends FeatureSource {
        private final ClasspathResourceSource source;

        FeatureClasspathSource(ClasspathResourceSource source) {
            this.source = source;
        }

        @Override
        TestSource nodeSource(Node node) {
            return ClasspathResourceSource.from((String)this.source.getClasspathResourceName(), (FilePosition)FeatureSource.createFilePosition(node.getLocation()));
        }

        @Override
        TestSource source() {
            return this.source;
        }
    }

    private static class FeatureFileSource
    extends FeatureSource {
        private final FileSource source;

        FeatureFileSource(FileSource source) {
            this.source = source;
        }

        @Override
        TestSource nodeSource(Node node) {
            return this.source.withPosition(FeatureSource.createFilePosition(node.getLocation()));
        }

        @Override
        TestSource source() {
            return this.source;
        }
    }

    private static class FeatureUriSource
    extends FeatureSource {
        private final UriSource source;

        FeatureUriSource(UriSource source) {
            this.source = source;
        }

        @Override
        TestSource nodeSource(Node node) {
            return this.source;
        }

        @Override
        TestSource source() {
            return this.source;
        }
    }
}

