/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.junit.platform.engine.FeatureOrigin;
import io.cucumber.plugin.event.Node;
import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.FilePosition;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

class CucumberDiscoverySelectors {
    CucumberDiscoverySelectors() {
    }

    static class FeatureElementSelector
    implements DiscoverySelector {
        private final Feature feature;
        private final Node element;

        private FeatureElementSelector(Feature feature) {
            this(feature, (Node)feature);
        }

        private FeatureElementSelector(Feature feature, Node element) {
            this.feature = Objects.requireNonNull(feature);
            this.element = Objects.requireNonNull(element);
        }

        static FeatureElementSelector selectFeature(Feature feature) {
            return new FeatureElementSelector(feature);
        }

        static FeatureElementSelector selectElement(Feature feature, Node element) {
            return new FeatureElementSelector(feature, element);
        }

        static Stream<FeatureElementSelector> selectElementsAt(Feature feature, Supplier<Optional<Set<FilePosition>>> filePositions, DiscoveryIssueReporter issueReporter) {
            return filePositions.get().map(positions -> FeatureElementSelector.selectElementsAt(feature, positions, issueReporter)).orElseGet(() -> Stream.of(FeatureElementSelector.selectFeature(feature)));
        }

        private static Stream<FeatureElementSelector> selectElementsAt(Feature feature, Set<FilePosition> filePositions, DiscoveryIssueReporter issueReporter) {
            return filePositions.stream().map(filePosition -> FeatureElementSelector.selectElementAt(feature, filePosition, issueReporter));
        }

        static FeatureElementSelector selectElementAt(Feature feature, Supplier<Optional<FilePosition>> filePosition, DiscoveryIssueReporter issueReporter) {
            return filePosition.get().map(position -> FeatureElementSelector.selectElementAt(feature, position, issueReporter)).orElseGet(() -> FeatureElementSelector.selectFeature(feature));
        }

        static FeatureElementSelector selectElementAt(Feature feature, FilePosition filePosition, DiscoveryIssueReporter issueReporter) {
            return feature.findPathTo(candidate -> candidate.getLocation().getLine() == filePosition.getLine()).map(nodes -> (Node)nodes.get(nodes.size() - 1)).map(node -> new FeatureElementSelector(feature, (Node)node)).orElseGet(() -> {
                FeatureElementSelector.reportInvalidFilePosition(feature, filePosition, issueReporter);
                return FeatureElementSelector.selectFeature(feature);
            });
        }

        private static void reportInvalidFilePosition(Feature feature, FilePosition filePosition, DiscoveryIssueReporter issueReporter) {
            issueReporter.reportIssue(DiscoveryIssue.create((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)("Feature file " + feature.getUri() + " does not have a feature, rule, scenario, or example element at line " + filePosition.getLine() + ". Selecting the whole feature instead")));
        }

        static Set<FeatureElementSelector> selectElementsOf(Feature feature, Node selected) {
            if (selected instanceof Node.Container) {
                Node.Container container = (Node.Container)selected;
                return container.elements().stream().map(element -> new FeatureElementSelector(feature, (Node)element)).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }

        Feature getFeature() {
            return this.feature;
        }

        Node getElement() {
            return this.element;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureElementSelector that = (FeatureElementSelector)o;
            return this.feature.equals(that.feature) && this.element.equals(that.element);
        }

        public int hashCode() {
            return Objects.hash(this.feature, this.element);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("feature", (Object)this.feature.getUri()).append("element", (Object)this.element.getLocation()).toString();
        }
    }

    static final class FeatureWithLinesSelector
    implements DiscoverySelector {
        private final URI uri;
        private final Set<FilePosition> filePositions;

        private FeatureWithLinesSelector(URI uri, Set<FilePosition> filePositions) {
            this.uri = Objects.requireNonNull(uri);
            this.filePositions = Objects.requireNonNull(filePositions);
        }

        static FeatureWithLinesSelector from(FeatureWithLines featureWithLines) {
            Set<FilePosition> lines = featureWithLines.lines().stream().map(FilePosition::from).collect(Collectors.toSet());
            return new FeatureWithLinesSelector(featureWithLines.uri(), lines);
        }

        static Set<FeatureWithLinesSelector> from(UniqueId uniqueId) {
            return uniqueId.getSegments().stream().filter(FeatureOrigin::isFeatureSegment).map(featureSegment -> {
                URI uri = URI.create(featureSegment.getValue());
                Set<FilePosition> filePosition = FeatureWithLinesSelector.getFilePosition(uniqueId.getLastSegment());
                return new FeatureWithLinesSelector(uri, filePosition);
            }).collect(Collectors.toSet());
        }

        static FeatureWithLinesSelector from(URI uri) {
            Set positions = FilePosition.fromQuery((String)uri.getQuery()).map(Collections::singleton).orElseGet(Collections::emptySet);
            return new FeatureWithLinesSelector(FeatureWithLinesSelector.stripQuery(uri), positions);
        }

        private static URI stripQuery(URI uri) {
            if (uri.getQuery() == null) {
                return uri;
            }
            String uriString = uri.toString();
            return URI.create(uriString.substring(0, uriString.indexOf(63)));
        }

        private static Set<FilePosition> getFilePosition(UniqueId.Segment segment) {
            if (FeatureOrigin.isFeatureSegment(segment)) {
                return Collections.emptySet();
            }
            int line = Integer.parseInt(segment.getValue());
            return Collections.singleton(FilePosition.from((int)line));
        }

        URI getUri() {
            return this.uri;
        }

        Optional<Set<FilePosition>> getFilePositions() {
            return this.filePositions.isEmpty() ? Optional.empty() : Optional.of(this.filePositions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureWithLinesSelector that = (FeatureWithLinesSelector)o;
            return this.uri.equals(that.uri) && this.filePositions.equals(that.filePositions);
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.filePositions);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("uri", (Object)this.uri).append("filePositions", this.filePositions).toString();
        }
    }
}

