/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;

final class ExclusiveResourceConfiguration {
    private final ConfigurationParameters configuration;

    ExclusiveResourceConfiguration(ConfigurationParameters configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    private Stream<String> exclusiveReadWriteResource() {
        return this.configuration.get(".read-write", s -> Arrays.stream(s.split(",")).map(String::trim)).orElse(Stream.empty());
    }

    private Stream<String> exclusiveReadResource() {
        return this.configuration.get(".read", s -> Arrays.stream(s.split(",")).map(String::trim)).orElse(Stream.empty());
    }

    Stream<ExclusiveResource> getExclusiveResources() {
        Stream<ExclusiveResource> readWrite = this.exclusiveReadWriteResource().map(resource -> new ExclusiveResource(resource, ExclusiveResource.LockMode.READ_WRITE));
        Stream<ExclusiveResource> read = this.exclusiveReadResource().map(resource -> new ExclusiveResource(resource, ExclusiveResource.LockMode.READ));
        return Stream.concat(readWrite, read);
    }
}

