/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.junit.platform.engine.FeatureDescriptor;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;

class CucumberEngineDescriptor
extends EngineDescriptor
implements Node<CucumberEngineExecutionContext> {
    static final String ENGINE_ID = "cucumber";
    private final TestSource source;

    CucumberEngineDescriptor(UniqueId uniqueId) {
        this(uniqueId, null);
    }

    CucumberEngineDescriptor(UniqueId uniqueId, TestSource source) {
        super(uniqueId, "Cucumber");
        this.source = source;
    }

    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public CucumberEngineExecutionContext prepare(CucumberEngineExecutionContext context) {
        return this.ifChildren(context, CucumberEngineExecutionContext::startTestRun);
    }

    public CucumberEngineExecutionContext before(CucumberEngineExecutionContext context) {
        return this.ifChildren(context, CucumberEngineExecutionContext::runBeforeAllHooks);
    }

    public void after(CucumberEngineExecutionContext context) {
        this.ifChildren(context, CucumberEngineExecutionContext::runAfterAllHooks);
    }

    public void cleanUp(CucumberEngineExecutionContext context) {
        this.ifChildren(context, CucumberEngineExecutionContext::finishTestRun);
    }

    private CucumberEngineExecutionContext ifChildren(CucumberEngineExecutionContext context, Consumer<CucumberEngineExecutionContext> action) {
        if (!this.getChildren().isEmpty()) {
            action.accept(context);
        }
        return context;
    }

    void mergeFeature(FeatureDescriptor descriptor) {
        CucumberEngineDescriptor.recursivelyMerge((TestDescriptor)descriptor, (TestDescriptor)this);
    }

    private static void recursivelyMerge(TestDescriptor descriptor, TestDescriptor parent) {
        Optional byUniqueId = parent.findByUniqueId(descriptor.getUniqueId());
        if (!byUniqueId.isPresent()) {
            parent.addChild(descriptor);
        } else {
            byUniqueId.ifPresent(existingParent -> descriptor.getChildren().forEach(child -> CucumberEngineDescriptor.recursivelyMerge(child, existingParent)));
        }
    }
}

