/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.junit.platform.engine.CucumberEngineDescriptor;
import io.cucumber.junit.platform.engine.CucumberEngineOptions;
import io.cucumber.junit.platform.engine.FeatureResolver;
import io.cucumber.junit.platform.engine.NodeDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;

class DiscoverySelectorResolver {
    private static final Logger log = LoggerFactory.getLogger(DiscoverySelectorResolver.class);
    private static boolean warnedWhenCucumberFeaturesPropertyIsUsed = false;

    DiscoverySelectorResolver() {
    }

    private static void warnWhenCucumberFeaturesPropertyIsUsed() {
        if (warnedWhenCucumberFeaturesPropertyIsUsed) {
            return;
        }
        warnedWhenCucumberFeaturesPropertyIsUsed = true;
        log.warn(() -> "Discovering tests using the cucumber.features property. Other discovery selectors are ignored!\n\nThis is a work around for the limited JUnit 5 support in Maven and Gradle. Please request/upvote/sponsor/ect better support for JUnit 5 discovery selectors. For details see: https://github.com/cucumber/cucumber-jvm/pull/2498\n\nIf you are using the JUnit 5 Suite Engine, Platform Launcher API or Console Launcher you should not use this property. Please consult the JUnit 5 documentation on test selection.");
    }

    void resolveSelectors(EngineDiscoveryRequest request, CucumberEngineDescriptor engineDescriptor) {
        Predicate<String> packageFilter = this.buildPackageFilter(request);
        this.resolve(request, engineDescriptor, packageFilter);
        this.filter((TestDescriptor)engineDescriptor, packageFilter);
        this.pruneTree((TestDescriptor)engineDescriptor);
    }

    private Predicate<String> buildPackageFilter(EngineDiscoveryRequest request) {
        Filter packageFilter = Filter.composeFilters((Collection)request.getFiltersByType(PackageNameFilter.class));
        return packageFilter.toPredicate();
    }

    private void resolve(EngineDiscoveryRequest request, CucumberEngineDescriptor engineDescriptor, Predicate<String> packageFilter) {
        ConfigurationParameters configuration = request.getConfigurationParameters();
        FeatureResolver featureResolver = FeatureResolver.create(configuration, engineDescriptor, packageFilter);
        CucumberEngineOptions options = new CucumberEngineOptions(configuration);
        List<FeatureWithLines> featureWithLines = options.featuresWithLines();
        if (!featureWithLines.isEmpty()) {
            DiscoverySelectorResolver.warnWhenCucumberFeaturesPropertyIsUsed();
            featureWithLines.forEach(featureResolver::resolveFeatureWithLines);
            return;
        }
        request.getSelectorsByType(ClasspathRootSelector.class).forEach(featureResolver::resolveClasspathRoot);
        request.getSelectorsByType(ClasspathResourceSelector.class).forEach(featureResolver::resolveClasspathResource);
        request.getSelectorsByType(ClassSelector.class).forEach(featureResolver::resolveClass);
        request.getSelectorsByType(PackageSelector.class).forEach(featureResolver::resolvePackageResource);
        request.getSelectorsByType(FileSelector.class).forEach(featureResolver::resolveFile);
        request.getSelectorsByType(DirectorySelector.class).forEach(featureResolver::resolveDirectory);
        request.getSelectorsByType(UniqueIdSelector.class).forEach(featureResolver::resolveUniqueId);
        request.getSelectorsByType(UriSelector.class).forEach(featureResolver::resolveUri);
    }

    private void filter(TestDescriptor engineDescriptor, Predicate<String> packageFilter) {
        this.applyPackagePredicate(packageFilter, engineDescriptor);
    }

    private void pruneTree(TestDescriptor rootDescriptor) {
        rootDescriptor.accept(TestDescriptor::prune);
    }

    private void applyPackagePredicate(Predicate<String> packageFilter, TestDescriptor engineDescriptor) {
        engineDescriptor.accept(descriptor -> {
            NodeDescriptor.PickleDescriptor pickleDescriptor;
            if (descriptor instanceof NodeDescriptor.PickleDescriptor && !this.includePickle(pickleDescriptor = (NodeDescriptor.PickleDescriptor)descriptor, packageFilter)) {
                descriptor.removeFromHierarchy();
            }
        });
    }

    private boolean includePickle(NodeDescriptor.PickleDescriptor pickleDescriptor, Predicate<String> packageFilter) {
        return pickleDescriptor.getPackage().map(packageFilter::test).orElse(true);
    }
}

