/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.options.ObjectFactoryParser;
import io.cucumber.core.options.PluginOption;
import io.cucumber.core.options.SnippetTypeParser;
import io.cucumber.core.plugin.NoPublishFormatter;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PublishFormatter;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.junit.platform.engine.DefaultNamingStrategy;
import io.cucumber.junit.platform.engine.NamingStrategy;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.ConfigurationParameters;

class CucumberEngineOptions
implements Options,
io.cucumber.core.runner.Options,
io.cucumber.core.backend.Options {
    private final ConfigurationParameters configurationParameters;

    CucumberEngineOptions(ConfigurationParameters configurationParameters) {
        this.configurationParameters = configurationParameters;
    }

    public List<Options.Plugin> plugins() {
        List plugins = this.configurationParameters.get("cucumber.plugin", s -> Arrays.stream(s.split(",")).map(String::trim).map(PluginOption::parse).map(pluginOption -> pluginOption).collect(Collectors.toList())).orElseGet(ArrayList::new);
        this.getPublishPlugin().ifPresent(plugins::add);
        return plugins;
    }

    private Optional<PluginOption> getPublishPlugin() {
        Optional<PluginOption> fromToken = this.getPublishTokenPlugin();
        Optional<PluginOption> fromEnabled = this.getPublishEnabledPlugin();
        Optional<PluginOption> plugin = Stream.of(fromToken, fromEnabled).flatMap(pluginOption -> pluginOption.map(Stream::of).orElseGet(Stream::empty)).findFirst();
        if (plugin.isPresent()) {
            return plugin;
        }
        return this.getPublishQuitePlugin();
    }

    private Optional<PluginOption> getPublishQuitePlugin() {
        Optional<PluginOption> noPublishOption = Optional.of(PluginOption.forClass(NoPublishFormatter.class));
        Optional quiteOption = Optional.empty();
        return this.configurationParameters.getBoolean("cucumber.publish.quiet").map(quite -> quite != false ? quiteOption : noPublishOption).orElse(noPublishOption);
    }

    private Optional<PluginOption> getPublishTokenPlugin() {
        return this.configurationParameters.get("cucumber.publish.token").map(token -> PluginOption.forClass(PublishFormatter.class, (String)token));
    }

    private Optional<PluginOption> getPublishEnabledPlugin() {
        Optional<PluginOption> enabledOption = Optional.of(PluginOption.forClass(PublishFormatter.class));
        Optional disabledOption = Optional.empty();
        return this.configurationParameters.getBoolean("cucumber.publish.enabled").flatMap(enabled -> enabled != false ? enabledOption : disabledOption);
    }

    public boolean isMonochrome() {
        return this.configurationParameters.getBoolean("cucumber.ansi-colors.disabled").orElse(false);
    }

    public boolean isWip() {
        return false;
    }

    Optional<Expression> tagFilter() {
        return this.configurationParameters.get("cucumber.filter.tags", TagExpressionParser::parse);
    }

    Optional<Pattern> nameFilter() {
        return this.configurationParameters.get("cucumber.filter.name", Pattern::compile);
    }

    public List<URI> getGlue() {
        return this.configurationParameters.get("cucumber.glue", s -> Arrays.asList(s.split(","))).orElse(Collections.singletonList("classpath:")).stream().map(String::trim).map(GluePath::parse).collect(Collectors.toList());
    }

    public boolean isDryRun() {
        return this.configurationParameters.getBoolean("cucumber.execution.dry-run").orElse(false);
    }

    public SnippetType getSnippetType() {
        return this.configurationParameters.get("cucumber.snippet-type", SnippetTypeParser::parseSnippetType).orElse(SnippetType.UNDERSCORE);
    }

    public Class<? extends ObjectFactory> getObjectFactoryClass() {
        return this.configurationParameters.get("cucumber.object-factory", ObjectFactoryParser::parseObjectFactory).orElse(null);
    }

    boolean isParallelExecutionEnabled() {
        return this.configurationParameters.getBoolean("cucumber.execution.parallel.enabled").orElse(false);
    }

    NamingStrategy namingStrategy() {
        return this.configurationParameters.get("cucumber.junit-platform.naming-strategy", DefaultNamingStrategy::getStrategy).orElse(DefaultNamingStrategy.SHORT);
    }
}

