/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.gherkin.Example;
import io.cucumber.core.gherkin.Examples;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Located;
import io.cucumber.core.gherkin.Named;
import io.cucumber.core.gherkin.Node;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.Rule;
import io.cucumber.core.gherkin.Scenario;
import io.cucumber.core.gherkin.ScenarioOutline;
import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.junit.platform.engine.FeatureOrigin;
import io.cucumber.junit.platform.engine.NodeDescriptor;
import io.cucumber.junit.platform.engine.PickleDescriptor;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

class FeatureDescriptor
extends AbstractTestDescriptor
implements org.junit.platform.engine.support.hierarchical.Node<CucumberEngineExecutionContext> {
    private final Feature feature;

    private FeatureDescriptor(UniqueId uniqueId, String name, TestSource source, Feature feature) {
        super(uniqueId, name, source);
        this.feature = feature;
    }

    static TestDescriptor create(Feature feature, TestDescriptor parent) {
        FeatureOrigin source = FeatureOrigin.fromUri(feature.getUri());
        FeatureDescriptor descriptor = new FeatureDescriptor(source.featureSegment(parent.getUniqueId(), feature), FeatureDescriptor.getNameOrKeyWord(feature), source.featureSource(), feature);
        parent.addChild((TestDescriptor)descriptor);
        feature.children().forEach(arg_0 -> FeatureDescriptor.lambda$create$0(feature, (TestDescriptor)descriptor, source, arg_0));
        return descriptor;
    }

    private static <T extends Located & Named> void visit(Feature feature, TestDescriptor parent, FeatureOrigin source, T node) {
        NodeDescriptor descriptor;
        if (node instanceof Scenario) {
            feature.getPickleAt(node).ifPresent(pickle -> {
                PickleDescriptor descriptor = new PickleDescriptor(source.scenarioSegment(parent.getUniqueId(), node), FeatureDescriptor.getNameOrKeyWord(node), source.nodeSource(node), (Pickle)pickle);
                parent.addChild((TestDescriptor)descriptor);
            });
        }
        if (node instanceof Rule) {
            descriptor = new NodeDescriptor(source.ruleSegment(parent.getUniqueId(), node), FeatureDescriptor.getNameOrKeyWord(node), source.nodeSource(node));
            parent.addChild((TestDescriptor)descriptor);
            Rule rule = (Rule)node;
            rule.children().forEach(section -> FeatureDescriptor.visit(feature, (TestDescriptor)descriptor, source, section));
        }
        if (node instanceof ScenarioOutline) {
            descriptor = new NodeDescriptor(source.scenarioSegment(parent.getUniqueId(), node), FeatureDescriptor.getNameOrKeyWord(node), source.nodeSource(node));
            parent.addChild((TestDescriptor)descriptor);
            ScenarioOutline scenarioOutline = (ScenarioOutline)node;
            scenarioOutline.children().forEach(section -> FeatureDescriptor.visit(feature, (TestDescriptor)descriptor, source, section));
        }
        if (node instanceof Examples) {
            descriptor = new NodeDescriptor(source.examplesSegment(parent.getUniqueId(), node), FeatureDescriptor.getNameOrKeyWord(node), source.nodeSource(node));
            parent.addChild((TestDescriptor)descriptor);
            Examples examples = (Examples)node;
            examples.children().forEach(example -> FeatureDescriptor.visit(feature, (TestDescriptor)descriptor, source, example));
        }
        if (node instanceof Example) {
            feature.getPickleAt(node).ifPresent(pickle -> {
                PickleDescriptor descriptor = new PickleDescriptor(source.exampleSegment(parent.getUniqueId(), node), FeatureDescriptor.getNameOrKeyWord(node), source.nodeSource(node), (Pickle)pickle);
                parent.addChild((TestDescriptor)descriptor);
            });
        }
    }

    private static <T extends Named> String getNameOrKeyWord(T node) {
        String name = node.getName();
        return name.isEmpty() ? node.getKeyWord() : name;
    }

    public CucumberEngineExecutionContext prepare(CucumberEngineExecutionContext context) {
        context.beforeFeature(this.feature);
        return context;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    private static /* synthetic */ void lambda$create$0(Feature feature, TestDescriptor descriptor, FeatureOrigin source, Node scenarioDefinition) {
        FeatureDescriptor.visit(feature, descriptor, source, scenarioDefinition);
    }
}

