/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.messages.GherkinMessagesLocation;
import io.cucumber.core.gherkin.messages.GherkinMessagesRule;
import io.cucumber.core.gherkin.messages.GherkinMessagesScenario;
import io.cucumber.core.gherkin.messages.GherkinMessagesScenarioOutline;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

final class GherkinMessagesFeature
implements Feature {
    private final io.cucumber.messages.types.Feature feature;
    private final URI uri;
    private final List<Pickle> pickles;
    private final List<Envelope> envelopes;
    private final String gherkinSource;
    private final List<Node> children;

    GherkinMessagesFeature(io.cucumber.messages.types.Feature feature, URI uri, String gherkinSource, List<Pickle> pickles, List<Envelope> envelopes) {
        this.feature = Objects.requireNonNull(feature);
        this.uri = Objects.requireNonNull(uri);
        this.gherkinSource = Objects.requireNonNull(gherkinSource);
        this.pickles = Objects.requireNonNull(pickles);
        this.envelopes = Objects.requireNonNull(envelopes);
        this.children = feature.getChildren().stream().filter(this::hasRuleOrScenario).map(this::mapRuleOrScenario).collect(Collectors.toList());
    }

    private Node mapRuleOrScenario(FeatureChild featureChild) {
        if (featureChild.getRule().isPresent()) {
            return new GherkinMessagesRule((Node)this, (Rule)featureChild.getRule().get());
        }
        Scenario scenario = (Scenario)featureChild.getScenario().get();
        if (!scenario.getExamples().isEmpty()) {
            return new GherkinMessagesScenarioOutline((Node)this, scenario);
        }
        return new GherkinMessagesScenario((Node)this, scenario);
    }

    private boolean hasRuleOrScenario(FeatureChild featureChild) {
        return featureChild.getRule().isPresent() || featureChild.getScenario().isPresent();
    }

    public Collection<Node> elements() {
        return this.children;
    }

    public Location getLocation() {
        return GherkinMessagesLocation.from(this.feature.getLocation());
    }

    public Optional<String> getKeyword() {
        return Optional.of(this.feature.getKeyword());
    }

    public Optional<String> getName() {
        String name = this.feature.getName();
        return name.isEmpty() ? Optional.empty() : Optional.of(name);
    }

    public Optional<Node> getParent() {
        return Optional.empty();
    }

    public Pickle getPickleAt(Node node) {
        Location location = node.getLocation();
        return this.pickles.stream().filter(pickle -> pickle.getLocation().equals((Object)location)).findFirst().orElseThrow(() -> new NoSuchElementException("No pickle in " + this.uri + " at " + location));
    }

    public List<Pickle> getPickles() {
        return this.pickles;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getSource() {
        return this.gherkinSource;
    }

    public Iterable<?> getParseEvents() {
        return this.envelopes;
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GherkinMessagesFeature that = (GherkinMessagesFeature)o;
        return this.uri.equals(that.uri);
    }
}

