/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.messages.GherkinMessagesLocation;
import io.cucumber.core.gherkin.messages.GherkinMessagesScenario;
import io.cucumber.core.gherkin.messages.GherkinMessagesScenarioOutline;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

final class GherkinMessagesRule
implements Node.Rule {
    private final Messages.GherkinDocument.Feature.FeatureChild.Rule rule;
    private final List<Node> children;

    GherkinMessagesRule(Messages.GherkinDocument.Feature.FeatureChild.Rule rule) {
        this.rule = rule;
        this.children = rule.getChildrenList().stream().filter(Messages.GherkinDocument.Feature.FeatureChild.RuleChild::hasScenario).map(ruleChild -> {
            Messages.GherkinDocument.Feature.Scenario scenario = ruleChild.getScenario();
            if (scenario.getExamplesCount() > 0) {
                return new GherkinMessagesScenarioOutline(scenario);
            }
            return new GherkinMessagesScenario(scenario);
        }).collect(Collectors.toList());
    }

    public Collection<Node> elements() {
        return this.children;
    }

    public Location getLocation() {
        return GherkinMessagesLocation.from(this.rule.getLocation());
    }

    public Optional<String> getKeyword() {
        return Optional.of(this.rule.getKeyword());
    }

    public Optional<String> getName() {
        String name = this.rule.getName();
        return name.isEmpty() ? Optional.empty() : Optional.of(name);
    }
}

