/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Ast;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.CucumberExpressionTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class CucumberExpressionParser {
    private static final Parser textParser = (expression, tokens, current) -> {
        Ast.Token token = (Ast.Token)tokens.get(current);
        switch (token.type) {
            case WHITE_SPACE: 
            case TEXT: 
            case END_OPTIONAL: 
            case END_PARAMETER: {
                return new Result(1, new Ast.Node[]{new Ast.Node(Ast.Node.Type.TEXT_NODE, token.start(), token.end(), token.text)});
            }
            case ALTERNATION: {
                throw CucumberExpressionException.createAlternationNotAllowedInOptional(expression, token);
            }
        }
        return new Result(0, new Ast.Node[0]);
    };
    private static final Parser nameParser = (expression, tokens, current) -> {
        Ast.Token token = (Ast.Token)tokens.get(current);
        switch (token.type) {
            case WHITE_SPACE: 
            case TEXT: {
                return new Result(1, new Ast.Node[]{new Ast.Node(Ast.Node.Type.TEXT_NODE, token.start(), token.end(), token.text)});
            }
            case BEGIN_OPTIONAL: 
            case END_OPTIONAL: 
            case BEGIN_PARAMETER: 
            case END_PARAMETER: 
            case ALTERNATION: {
                throw CucumberExpressionException.createInvalidParameterTypeName(token, expression);
            }
        }
        return new Result(0, new Ast.Node[0]);
    };
    private static final Parser parameterParser = CucumberExpressionParser.parseBetween(Ast.Node.Type.PARAMETER_NODE, Ast.Token.Type.BEGIN_PARAMETER, Ast.Token.Type.END_PARAMETER, Collections.singletonList(nameParser));
    private static final Parser optionalParser;
    private static final Parser alternativeSeparator;
    private static final List<Parser> alternativeParsers;
    private static final Parser alternationParser;
    private static final Parser cucumberExpressionParser;

    CucumberExpressionParser() {
    }

    Ast.Node parse(String expression) {
        CucumberExpressionTokenizer tokenizer = new CucumberExpressionTokenizer();
        List<Ast.Token> tokens = tokenizer.tokenize(expression);
        Result result = cucumberExpressionParser.parse(expression, tokens, 0);
        return result.ast.get(0);
    }

    private static Parser parseBetween(Ast.Node.Type type, Ast.Token.Type beginToken, Ast.Token.Type endToken, List<Parser> parsers) {
        return (expression, tokens, current) -> {
            if (!CucumberExpressionParser.lookingAt(tokens, current, beginToken)) {
                return new Result(0, new Ast.Node[0]);
            }
            int subCurrent = current + 1;
            Result result = CucumberExpressionParser.parseTokensUntil(expression, parsers, tokens, subCurrent, endToken, Ast.Token.Type.END_OF_LINE);
            if (!CucumberExpressionParser.lookingAt(tokens, subCurrent += result.consumed, endToken)) {
                throw CucumberExpressionException.createMissingEndToken(expression, beginToken, endToken, (Ast.Token)tokens.get(current));
            }
            int start = ((Ast.Token)tokens.get(current)).start();
            int end = ((Ast.Token)tokens.get(subCurrent)).end();
            return new Result(subCurrent + 1 - current, new Ast.Node[]{new Ast.Node(type, start, end, result.ast)});
        };
    }

    private static Result parseTokensUntil(String expression, List<Parser> parsers, List<Ast.Token> tokens, int startAt, Ast.Token.Type ... endTokens) {
        int current;
        Result result;
        int size = tokens.size();
        ArrayList<Ast.Node> ast = new ArrayList<Ast.Node>();
        for (current = startAt; current < size && !CucumberExpressionParser.lookingAtAny(tokens, current, endTokens); current += result.consumed) {
            result = CucumberExpressionParser.parseToken(expression, parsers, tokens, current);
            if (result.consumed == 0) {
                throw new IllegalStateException("No eligible parsers for " + tokens);
            }
            ast.addAll(result.ast);
        }
        return new Result(current - startAt, ast);
    }

    private static Result parseToken(String expression, List<Parser> parsers, List<Ast.Token> tokens, int startAt) {
        for (Parser parser : parsers) {
            Result result = parser.parse(expression, tokens, startAt);
            if (result.consumed == 0) continue;
            return result;
        }
        throw new IllegalStateException("No eligible parsers for " + tokens);
    }

    private static boolean lookingAtAny(List<Ast.Token> tokens, int at, Ast.Token.Type ... tokenTypes) {
        for (Ast.Token.Type tokeType : tokenTypes) {
            if (!CucumberExpressionParser.lookingAt(tokens, at, tokeType)) continue;
            return true;
        }
        return false;
    }

    private static boolean lookingAt(List<Ast.Token> tokens, int at, Ast.Token.Type token) {
        if (at < 0) {
            return token == Ast.Token.Type.START_OF_LINE;
        }
        if (at >= tokens.size()) {
            return token == Ast.Token.Type.END_OF_LINE;
        }
        return tokens.get((int)at).type == token;
    }

    private static List<Ast.Node> splitAlternatives(int start, int end, List<Ast.Node> alternation) {
        ArrayList<Ast.Node> separators = new ArrayList<Ast.Node>();
        ArrayList<List<Ast.Node>> alternatives = new ArrayList<List<Ast.Node>>();
        ArrayList<Ast.Node> alternative = new ArrayList<Ast.Node>();
        for (Ast.Node n : alternation) {
            if (Ast.Node.Type.ALTERNATIVE_NODE.equals((Object)n.type())) {
                separators.add(n);
                alternatives.add(alternative);
                alternative = new ArrayList();
                continue;
            }
            alternative.add(n);
        }
        alternatives.add(alternative);
        return CucumberExpressionParser.createAlternativeNodes(start, end, separators, alternatives);
    }

    private static List<Ast.Node> createAlternativeNodes(int start, int end, List<Ast.Node> separators, List<List<Ast.Node>> alternatives) {
        ArrayList<Ast.Node> nodes = new ArrayList<Ast.Node>();
        for (int i = 0; i < alternatives.size(); ++i) {
            Ast.Node leftSeparator;
            List<Ast.Node> n = alternatives.get(i);
            if (i == 0) {
                Ast.Node rightSeparator = separators.get(i);
                nodes.add(new Ast.Node(Ast.Node.Type.ALTERNATIVE_NODE, start, rightSeparator.start(), n));
                continue;
            }
            if (i == alternatives.size() - 1) {
                leftSeparator = separators.get(i - 1);
                nodes.add(new Ast.Node(Ast.Node.Type.ALTERNATIVE_NODE, leftSeparator.end(), end, n));
                continue;
            }
            leftSeparator = separators.get(i - 1);
            Ast.Node rightSeparator = separators.get(i);
            nodes.add(new Ast.Node(Ast.Node.Type.ALTERNATIVE_NODE, leftSeparator.end(), rightSeparator.start(), n));
        }
        return nodes;
    }

    static {
        ArrayList<Parser> parsers = new ArrayList<Parser>();
        optionalParser = CucumberExpressionParser.parseBetween(Ast.Node.Type.OPTIONAL_NODE, Ast.Token.Type.BEGIN_OPTIONAL, Ast.Token.Type.END_OPTIONAL, parsers);
        parsers.addAll(Arrays.asList(optionalParser, parameterParser, textParser));
        alternativeSeparator = (expression, tokens, current) -> {
            if (!CucumberExpressionParser.lookingAt(tokens, current, Ast.Token.Type.ALTERNATION)) {
                return new Result(0, new Ast.Node[0]);
            }
            Ast.Token token = (Ast.Token)tokens.get(current);
            return new Result(1, new Ast.Node[]{new Ast.Node(Ast.Node.Type.ALTERNATIVE_NODE, token.start(), token.end(), token.text)});
        };
        alternativeParsers = Arrays.asList(alternativeSeparator, optionalParser, parameterParser, textParser);
        alternationParser = (expression, tokens, current) -> {
            int previous = current - 1;
            if (!CucumberExpressionParser.lookingAtAny(tokens, previous, Ast.Token.Type.START_OF_LINE, Ast.Token.Type.WHITE_SPACE, Ast.Token.Type.END_PARAMETER)) {
                return new Result(0, new Ast.Node[0]);
            }
            Result result = CucumberExpressionParser.parseTokensUntil(expression, alternativeParsers, tokens, current, Ast.Token.Type.WHITE_SPACE, Ast.Token.Type.END_OF_LINE, Ast.Token.Type.BEGIN_PARAMETER);
            int subCurrent = current + result.consumed;
            if (result.ast.stream().noneMatch(astNode -> astNode.type() == Ast.Node.Type.ALTERNATIVE_NODE)) {
                return new Result(0, new Ast.Node[0]);
            }
            int start = ((Ast.Token)tokens.get(current)).start();
            int end = ((Ast.Token)tokens.get(subCurrent)).start();
            return new Result(result.consumed, new Ast.Node[]{new Ast.Node(Ast.Node.Type.ALTERNATION_NODE, start, end, CucumberExpressionParser.splitAlternatives(start, end, result.ast))});
        };
        cucumberExpressionParser = CucumberExpressionParser.parseBetween(Ast.Node.Type.EXPRESSION_NODE, Ast.Token.Type.START_OF_LINE, Ast.Token.Type.END_OF_LINE, Arrays.asList(alternationParser, optionalParser, parameterParser, textParser));
    }

    private static interface Parser {
        public Result parse(String var1, List<Ast.Token> var2, int var3);
    }

    private static final class Result {
        final int consumed;
        final List<Ast.Node> ast;

        private Result(int consumed, Ast.Node ... ast) {
            this(consumed, Arrays.asList(ast));
        }

        private Result(int consumed, List<Ast.Node> ast) {
            this.consumed = consumed;
            this.ast = ast;
        }
    }
}

