/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.filter.Filters;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.order.PickleOrder;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.CucumberExecutionContext;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.FeatureSupplier;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.SingletonObjectFactorySupplier;
import io.cucumber.core.runtime.SingletonRunnerSupplier;
import io.cucumber.core.runtime.SynchronizedEventBus;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.core.runtime.UuidGeneratorServiceLoader;
import io.cucumber.plugin.Plugin;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Runtime {
    private static final Logger log = LoggerFactory.getLogger(Runtime.class);
    private final ExitStatus exitStatus;
    private final Predicate<Pickle> filter;
    private final int limit;
    private final FeatureSupplier featureSupplier;
    private final ExecutorService executor;
    private final PickleOrder pickleOrder;
    private final CucumberExecutionContext context;

    private Runtime(ExitStatus exitStatus, CucumberExecutionContext context, Predicate<Pickle> filter, int limit, FeatureSupplier featureSupplier, ExecutorService executor, PickleOrder pickleOrder) {
        this.filter = filter;
        this.context = context;
        this.limit = limit;
        this.featureSupplier = featureSupplier;
        this.executor = executor;
        this.exitStatus = exitStatus;
        this.pickleOrder = pickleOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void run() {
        List<Feature> features = this.featureSupplier.get();
        this.context.runFeatures(() -> this.runFeatures(features));
    }

    private void runFeatures(List<Feature> features) {
        features.forEach(this.context::beforeFeature);
        List executingPickles = features.stream().flatMap(feature -> feature.getPickles().stream()).filter(this.filter).collect(Collectors.collectingAndThen(Collectors.toList(), list -> this.pickleOrder.orderPickles((List<Pickle>)list).stream())).limit(this.limit > 0 ? (long)this.limit : Integer.MAX_VALUE).map(pickle -> this.executor.submit(this.executePickle((Pickle)pickle))).collect(Collectors.toList());
        this.executor.shutdown();
        for (Future executingPickle : executingPickles) {
            try {
                executingPickle.get();
            }
            catch (ExecutionException e) {
                log.error(e, () -> "Exception while executing pickle");
            }
            catch (InterruptedException e) {
                log.debug(e, () -> "Interrupted while executing pickle");
                this.executor.shutdownNow();
            }
        }
    }

    private Runnable executePickle(Pickle pickle) {
        return () -> this.context.runTestCase(runner -> runner.runPickle(pickle));
    }

    public byte exitStatus() {
        return this.exitStatus.exitStatus();
    }

    public static class Builder {
        private EventBus eventBus;
        private Supplier<ClassLoader> classLoader = ClassLoaders::getDefaultClassLoader;
        private RuntimeOptions runtimeOptions = RuntimeOptions.defaultOptions();
        private BackendSupplier backendSupplier;
        private ObjectFactorySupplier objectFactorySupplier;
        private FeatureSupplier featureSupplier;
        private List<Plugin> additionalPlugins = Collections.emptyList();
        private Supplier<UuidGenerator> uuidGeneratorSupplier;

        private Builder() {
        }

        public Builder withRuntimeOptions(RuntimeOptions runtimeOptions) {
            this.runtimeOptions = runtimeOptions;
            return this;
        }

        public Builder withClassLoader(Supplier<ClassLoader> classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder withBackendSupplier(BackendSupplier backendSupplier) {
            this.backendSupplier = backendSupplier;
            return this;
        }

        public Builder withObjectFactorySupplier(ObjectFactorySupplier objectFactorySupplier) {
            this.objectFactorySupplier = objectFactorySupplier;
            return this;
        }

        public Builder withFeatureSupplier(FeatureSupplier featureSupplier) {
            this.featureSupplier = featureSupplier;
            return this;
        }

        public Builder withUuidGeneratorSupplier(Supplier<UuidGenerator> uuidGenerator) {
            this.uuidGeneratorSupplier = uuidGenerator;
            return this;
        }

        public Builder withAdditionalPlugins(Plugin ... plugins) {
            this.additionalPlugins = Arrays.asList(plugins);
            return this;
        }

        public Builder withEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Runtime build() {
            SynchronizedEventBus eventBus = SynchronizedEventBus.synchronize(this.createEventBus());
            ExitStatus exitStatus = this.createPluginsAndExitStatus(eventBus);
            RunnerSupplier runnerSupplier = this.createRunnerSupplier(eventBus);
            CucumberExecutionContext context = new CucumberExecutionContext(eventBus, exitStatus, runnerSupplier);
            Filters filter = new Filters(this.runtimeOptions);
            int limit = this.runtimeOptions.getLimitCount();
            FeatureSupplier featureSupplier = this.createFeatureSupplier(eventBus);
            ExecutorService executor = this.createExecutorService();
            PickleOrder pickleOrder = this.runtimeOptions.getPickleOrder();
            return new Runtime(exitStatus, context, filter, limit, featureSupplier, executor, pickleOrder);
        }

        private ExitStatus createPluginsAndExitStatus(EventBus eventBus) {
            Plugins plugins = this.createPlugins();
            ExitStatus exitStatus = new ExitStatus(this.runtimeOptions);
            plugins.addPlugin((Plugin)exitStatus);
            if (this.runtimeOptions.isMultiThreaded()) {
                plugins.setSerialEventBusOnEventListenerPlugins(eventBus);
            } else {
                plugins.setEventBusOnEventListenerPlugins(eventBus);
            }
            return exitStatus;
        }

        private RunnerSupplier createRunnerSupplier(EventBus eventBus) {
            ObjectFactorySupplier objectFactorySupplier = this.createObjectFactorySupplier();
            BackendSupplier backendSupplier = this.createBackendSupplier(objectFactorySupplier);
            return this.runtimeOptions.isMultiThreaded() ? new ThreadLocalRunnerSupplier(this.runtimeOptions, eventBus, backendSupplier, objectFactorySupplier) : new SingletonRunnerSupplier(this.runtimeOptions, eventBus, backendSupplier, objectFactorySupplier);
        }

        private ObjectFactorySupplier createObjectFactorySupplier() {
            if (this.objectFactorySupplier != null) {
                return this.objectFactorySupplier;
            }
            ObjectFactoryServiceLoader objectFactoryServiceLoader = new ObjectFactoryServiceLoader(this.classLoader, this.runtimeOptions);
            return this.runtimeOptions.isMultiThreaded() ? new ThreadLocalObjectFactorySupplier(objectFactoryServiceLoader) : new SingletonObjectFactorySupplier(objectFactoryServiceLoader);
        }

        private BackendSupplier createBackendSupplier(ObjectFactorySupplier objectFactorySupplier) {
            return this.backendSupplier != null ? this.backendSupplier : new BackendServiceLoader(this.classLoader, objectFactorySupplier);
        }

        private EventBus createEventBus() {
            if (this.eventBus != null) {
                return this.eventBus;
            }
            UuidGenerator uuidGenerator = this.createUuidGenerator();
            return new TimeServiceEventBus(Clock.systemUTC(), uuidGenerator);
        }

        private UuidGenerator createUuidGenerator() {
            if (this.uuidGeneratorSupplier != null) {
                return this.uuidGeneratorSupplier.get();
            }
            return new UuidGeneratorServiceLoader(this.classLoader, this.runtimeOptions).loadUuidGenerator();
        }

        private FeatureSupplier createFeatureSupplier(EventBus eventBus) {
            if (this.featureSupplier != null) {
                return this.featureSupplier;
            }
            FeatureParser parser = new FeatureParser(eventBus::generateId);
            return new FeaturePathFeatureSupplier(this.classLoader, this.runtimeOptions, parser);
        }

        private ExecutorService createExecutorService() {
            return this.runtimeOptions.isMultiThreaded() ? Executors.newFixedThreadPool(this.runtimeOptions.getThreads(), new CucumberThreadFactory()) : new SameThreadExecutorService();
        }

        private Plugins createPlugins() {
            Plugins plugins = new Plugins(new PluginFactory(), this.runtimeOptions);
            for (Plugin plugin : this.additionalPlugins) {
                plugins.addPlugin(plugin);
            }
            return plugins;
        }
    }

    private static final class SameThreadExecutorService
    extends AbstractExecutorService {
        private SameThreadExecutorService() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }
    }

    private static final class CucumberThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "cucumber-runner-" + poolNumber.getAndIncrement() + "-thread-";

        CucumberThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
        }
    }
}

