/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.exception.CompositeCucumberException;
import io.cucumber.core.exception.ExceptionUtils;
import io.cucumber.core.exception.UnrecoverableExceptions;
import io.cucumber.core.runtime.TestCaseFailed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

final class RethrowingThrowableCollector {
    private final List<Throwable> thrown = Collections.synchronizedList(new ArrayList());

    RethrowingThrowableCollector() {
    }

    void executeAndThrow(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (TestCaseFailed e) {
            ExceptionUtils.throwAsUncheckedException(e.getCause());
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
            this.add(t);
            ExceptionUtils.throwAsUncheckedException(t);
        }
    }

    <T> T executeAndThrow(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
            this.thrown.add(t);
            ExceptionUtils.throwAsUncheckedException(t);
            return null;
        }
    }

    void add(Throwable throwable) {
        this.thrown.add(throwable);
    }

    Throwable getThrowable() {
        if (this.thrown.isEmpty()) {
            return null;
        }
        if (this.thrown.size() == 1) {
            return this.thrown.get(0);
        }
        return new CompositeCucumberException(this.thrown);
    }
}

