/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.teamcityformatter.MessagesToTeamCityWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class TeamCityPlugin
implements ConcurrentEventListener {
    private final OutputStream out;
    private MessagesToTeamCityWriter writer;

    public TeamCityPlugin() {
        this(new PrintStream(System.out){

            @Override
            public void close() {
            }
        });
    }

    TeamCityPlugin(OutputStream out) {
        this.out = out;
    }

    public void setEventPublisher(EventPublisher publisher) {
        this.setEventPublisher(publisher, true);
    }

    public void setEventPublisher(EventPublisher publisher, boolean isMultiThreaded) {
        this.writer = MessagesToTeamCityWriter.builder().feature(MessagesToTeamCityWriter.TeamCityFeature.PRINT_TEST_CASES_AFTER_TEST_RUN, isMultiThreaded).build(this.out);
        publisher.registerHandlerFor(Envelope.class, this::write);
    }

    private void write(Envelope event) {
        try {
            this.writer.write(event);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (event.getTestRunFinished().isPresent()) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

