/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.gherkin.Step;
import io.cucumber.core.runner.PickleStepDefinitionMatch;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class AmbiguousStepDefinitionsException
extends Exception {
    private final List<PickleStepDefinitionMatch> matches;

    AmbiguousStepDefinitionsException(Step step, List<PickleStepDefinitionMatch> matches) {
        super(AmbiguousStepDefinitionsException.createMessage(step, matches));
        this.matches = matches;
    }

    private static String createMessage(Step step, List<PickleStepDefinitionMatch> matches) {
        Objects.requireNonNull(step);
        Objects.requireNonNull(matches);
        return AmbiguousStepDefinitionsException.quoteText(step.getText()) + " matches more than one step definition:\n" + matches.stream().map(match -> "  " + AmbiguousStepDefinitionsException.quoteText(match.getPattern()) + " in " + match.getLocation()).collect(Collectors.joining("\n"));
    }

    private static String quoteText(String text) {
        return "\"" + text + "\"";
    }

    List<PickleStepDefinitionMatch> getMatches() {
        return this.matches;
    }
}

