/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.Jackson;
import io.cucumber.jsonformatter.MessagesToJsonWriter;
import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;

public final class JsonFormatter
implements ConcurrentEventListener {
    private final MessagesToJsonWriter writer;

    public JsonFormatter(OutputStream out) {
        URI cwdUri = new File("").toURI();
        this.writer = MessagesToJsonWriter.builder(Jackson.OBJECT_MAPPER::writeValue).relativizeAgainst(cwdUri).build(out);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::write);
    }

    private void write(Envelope event) {
        try {
            this.writer.write(event);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (event.getTestRunFinished().isPresent()) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

