/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.resource;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.core.resource.CloseablePath;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

class JarUriFileSystemService {
    private static final String FILE_URI_SCHEME = "file";
    private static final String JAR_URI_SCHEME = "jar";
    private static final String JAR_URI_SCHEME_PREFIX = "jar:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static final String JAR_URI_SEPARATOR = "!/";
    private static final Map<URI, FileSystem> openFiles = new HashMap<URI, FileSystem>();
    private static final Map<URI, AtomicInteger> referenceCount = new HashMap<URI, AtomicInteger>();

    JarUriFileSystemService() {
    }

    private static CloseablePath open(URI jarUri, Function<FileSystem, Path> pathProvider) throws IOException {
        FileSystem fileSystem = JarUriFileSystemService.openFileSystem(jarUri);
        Path path = pathProvider.apply(fileSystem);
        return CloseablePath.open(path, () -> JarUriFileSystemService.closeFileSystem(jarUri));
    }

    private static synchronized void closeFileSystem(URI jarUri) throws IOException {
        int referents = referenceCount.get(jarUri).decrementAndGet();
        if (referents == 0) {
            openFiles.remove(jarUri).close();
            referenceCount.remove(jarUri);
        }
    }

    private static synchronized FileSystem openFileSystem(URI jarUri) throws IOException {
        FileSystem existing = openFiles.get(jarUri);
        if (existing != null) {
            referenceCount.get(jarUri).getAndIncrement();
            return existing;
        }
        FileSystem fileSystem = FileSystems.newFileSystem(jarUri, Collections.emptyMap());
        openFiles.put(jarUri, fileSystem);
        referenceCount.put(jarUri, new AtomicInteger(1));
        return fileSystem;
    }

    static boolean supports(URI uri) {
        return JarUriFileSystemService.hasJarUriScheme(uri) || JarUriFileSystemService.hasFileUriSchemeWithJarExtension(uri);
    }

    private static boolean hasJarUriScheme(URI uri) {
        return JAR_URI_SCHEME.equals(uri.getScheme());
    }

    private static boolean hasFileUriSchemeWithJarExtension(URI uri) {
        return FILE_URI_SCHEME.equals(uri.getScheme()) && uri.getPath().endsWith(JAR_FILE_SUFFIX);
    }

    static CloseablePath open(URI uri) throws URISyntaxException, IOException {
        assert (JarUriFileSystemService.supports(uri));
        if (JarUriFileSystemService.hasFileUriSchemeWithJarExtension(uri)) {
            return JarUriFileSystemService.handleFileUriSchemeWithJarExtension(uri);
        }
        if (JarUriFileSystemService.isSpringBoot31OrLower(uri)) {
            return JarUriFileSystemService.handleSpringBoot31JarUri(uri);
        }
        return JarUriFileSystemService.handleJarUriScheme(uri);
    }

    private static CloseablePath handleFileUriSchemeWithJarExtension(URI uri) throws IOException, URISyntaxException {
        return JarUriFileSystemService.open(new URI(JAR_URI_SCHEME_PREFIX + uri), fileSystem -> fileSystem.getRootDirectories().iterator().next());
    }

    private static CloseablePath handleJarUriScheme(URI uri) throws IOException, URISyntaxException {
        String uriString = uri.toString();
        int lastJarUriSeparator = uriString.lastIndexOf(JAR_URI_SEPARATOR);
        if (lastJarUriSeparator < 0) {
            throw new IllegalArgumentException(String.format("jar uri '%s' must contain '%s'", uri, JAR_URI_SEPARATOR));
        }
        String url = uriString.substring(0, lastJarUriSeparator);
        String entry = uriString.substring(lastJarUriSeparator + 1);
        return JarUriFileSystemService.open(new URI(url), fileSystem -> fileSystem.getPath(entry, new String[0]));
    }

    private static boolean isSpringBoot31OrLower(URI uri) {
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        return schemeSpecificPart.startsWith("file:") && schemeSpecificPart.contains("!/BOOT-INF");
    }

    private static CloseablePath handleSpringBoot31JarUri(URI uri) throws IOException, URISyntaxException {
        String[] parts = uri.toString().split("!");
        String jarUri = parts[0];
        String jarEntry = parts[1];
        String subEntry = parts[2];
        if (jarEntry.endsWith(JAR_FILE_SUFFIX)) {
            throw new CucumberException(ClasspathSupport.nestedJarEntriesExplanation(uri));
        }
        return JarUriFileSystemService.open(new URI(jarUri), fileSystem -> fileSystem.getPath(jarEntry + subEntry, new String[0]));
    }
}

