/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import io.cucumber.core.feature.FeaturePath;
import java.net.URI;
import java.nio.file.Path;

public class FeatureIdentifier {
    private static final String FEATURE_FILE_SUFFIX = ".feature";

    private FeatureIdentifier() {
    }

    public static URI parse(String featureIdentifier) {
        return FeatureIdentifier.parse(FeaturePath.parse(featureIdentifier));
    }

    public static URI parse(URI featureIdentifier) {
        if (!FeatureIdentifier.isFeature(featureIdentifier)) {
            throw new IllegalArgumentException("featureIdentifier does not reference a single feature file: " + featureIdentifier);
        }
        return featureIdentifier;
    }

    public static boolean isFeature(URI featureIdentifier) {
        return featureIdentifier.getSchemeSpecificPart().endsWith(FEATURE_FILE_SUFFIX);
    }

    public static boolean isFeature(Path path) {
        return path.getFileName().toString().endsWith(FEATURE_FILE_SUFFIX);
    }
}

