/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.DefaultDataTableCellTransformerDefinition;
import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.DefaultParameterTransformerDefinition;
import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.JavaMethodReference;
import io.cucumber.core.backend.Located;
import io.cucumber.core.backend.ParameterTypeDefinition;
import io.cucumber.core.backend.ScenarioScoped;
import io.cucumber.core.backend.SourceReference;
import io.cucumber.core.backend.StackTraceElementReference;
import io.cucumber.core.backend.StaticHookDefinition;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.runner.AmbiguousStepDefinitionsException;
import io.cucumber.core.runner.CoreDefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.runner.CoreHookDefinition;
import io.cucumber.core.runner.CoreStepDefinition;
import io.cucumber.core.runner.DuplicateDefaultDataTableCellTransformers;
import io.cucumber.core.runner.DuplicateDefaultDataTableEntryTransformers;
import io.cucumber.core.runner.DuplicateDefaultParameterTransformers;
import io.cucumber.core.runner.DuplicateStepDefinitionException;
import io.cucumber.core.runner.PickleStepDefinitionMatch;
import io.cucumber.core.stepexpression.Argument;
import io.cucumber.core.stepexpression.StepExpression;
import io.cucumber.core.stepexpression.StepExpressionFactory;
import io.cucumber.core.stepexpression.StepTypeRegistry;
import io.cucumber.cucumberexpressions.CucumberExpression;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import io.cucumber.cucumberexpressions.RegularExpression;
import io.cucumber.datatable.TableCellByTypeTransformer;
import io.cucumber.datatable.TableEntryByTypeTransformer;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Hook;
import io.cucumber.messages.types.HookType;
import io.cucumber.messages.types.JavaMethod;
import io.cucumber.messages.types.JavaStackTraceElement;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.ParameterType;
import io.cucumber.messages.types.StepDefinitionPattern;
import io.cucumber.messages.types.StepDefinitionPatternType;
import io.cucumber.plugin.event.StepDefinedEvent;
import io.cucumber.plugin.event.StepDefinition;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class CachingGlue
implements Glue {
    private static final Comparator<CoreHookDefinition> HOOK_ORDER_ASCENDING = Comparator.comparingInt(CoreHookDefinition::getOrder).thenComparing(ScenarioScoped.class::isInstance);
    private static final Comparator<StaticHookDefinition> STATIC_HOOK_ORDER_ASCENDING = Comparator.comparingInt(StaticHookDefinition::getOrder);
    private final List<ParameterTypeDefinition> parameterTypeDefinitions = new ArrayList<ParameterTypeDefinition>();
    private final List<DataTableTypeDefinition> dataTableTypeDefinitions = new ArrayList<DataTableTypeDefinition>();
    private final List<DefaultParameterTransformerDefinition> defaultParameterTransformers = new ArrayList<DefaultParameterTransformerDefinition>();
    private final List<CoreDefaultDataTableEntryTransformerDefinition> defaultDataTableEntryTransformers = new ArrayList<CoreDefaultDataTableEntryTransformerDefinition>();
    private final List<DefaultDataTableCellTransformerDefinition> defaultDataTableCellTransformers = new ArrayList<DefaultDataTableCellTransformerDefinition>();
    private final List<DocStringTypeDefinition> docStringTypeDefinitions = new ArrayList<DocStringTypeDefinition>();
    private final List<StaticHookDefinition> beforeAllHooks = new ArrayList<StaticHookDefinition>();
    private final List<CoreHookDefinition> beforeHooks = new ArrayList<CoreHookDefinition>();
    private final List<CoreHookDefinition> beforeStepHooks = new ArrayList<CoreHookDefinition>();
    private final List<io.cucumber.core.backend.StepDefinition> stepDefinitions = new ArrayList<io.cucumber.core.backend.StepDefinition>();
    private final List<CoreHookDefinition> afterStepHooks = new ArrayList<CoreHookDefinition>();
    private final List<CoreHookDefinition> afterHooks = new ArrayList<CoreHookDefinition>();
    private final List<StaticHookDefinition> afterAllHooks = new ArrayList<StaticHookDefinition>();
    private final Map<String, String> stepPatternByStepText = new HashMap<String, String>();
    private final Map<String, CoreStepDefinition> stepDefinitionsByPattern = new TreeMap<String, CoreStepDefinition>();
    private final EventBus bus;

    CachingGlue(EventBus bus) {
        this.bus = bus;
    }

    @Override
    public void addBeforeAllHook(StaticHookDefinition beforeAllHook) {
        this.beforeAllHooks.add(beforeAllHook);
        this.beforeAllHooks.sort(STATIC_HOOK_ORDER_ASCENDING);
    }

    @Override
    public void addAfterAllHook(StaticHookDefinition afterAllHook) {
        this.afterAllHooks.add(afterAllHook);
        this.afterAllHooks.sort(STATIC_HOOK_ORDER_ASCENDING);
    }

    @Override
    public void addStepDefinition(io.cucumber.core.backend.StepDefinition stepDefinition) {
        this.stepDefinitions.add(stepDefinition);
    }

    @Override
    public void addBeforeHook(HookDefinition hookDefinition) {
        this.beforeHooks.add(CoreHookDefinition.create(hookDefinition, this.bus::generateId));
        this.beforeHooks.sort(HOOK_ORDER_ASCENDING);
    }

    @Override
    public void addAfterHook(HookDefinition hookDefinition) {
        this.afterHooks.add(CoreHookDefinition.create(hookDefinition, this.bus::generateId));
        this.afterHooks.sort(HOOK_ORDER_ASCENDING);
    }

    @Override
    public void addBeforeStepHook(HookDefinition hookDefinition) {
        this.beforeStepHooks.add(CoreHookDefinition.create(hookDefinition, this.bus::generateId));
        this.beforeStepHooks.sort(HOOK_ORDER_ASCENDING);
    }

    @Override
    public void addAfterStepHook(HookDefinition hookDefinition) {
        this.afterStepHooks.add(CoreHookDefinition.create(hookDefinition, this.bus::generateId));
        this.afterStepHooks.sort(HOOK_ORDER_ASCENDING);
    }

    @Override
    public void addParameterType(ParameterTypeDefinition parameterType) {
        this.parameterTypeDefinitions.add(parameterType);
    }

    @Override
    public void addDataTableType(DataTableTypeDefinition dataTableType) {
        this.dataTableTypeDefinitions.add(dataTableType);
    }

    @Override
    public void addDefaultParameterTransformer(DefaultParameterTransformerDefinition defaultParameterTransformer) {
        this.defaultParameterTransformers.add(defaultParameterTransformer);
    }

    @Override
    public void addDefaultDataTableEntryTransformer(DefaultDataTableEntryTransformerDefinition defaultDataTableEntryTransformer) {
        this.defaultDataTableEntryTransformers.add(CoreDefaultDataTableEntryTransformerDefinition.create(defaultDataTableEntryTransformer));
    }

    @Override
    public void addDefaultDataTableCellTransformer(DefaultDataTableCellTransformerDefinition defaultDataTableCellTransformer) {
        this.defaultDataTableCellTransformers.add(defaultDataTableCellTransformer);
    }

    @Override
    public void addDocStringType(DocStringTypeDefinition docStringType) {
        this.docStringTypeDefinitions.add(docStringType);
    }

    List<StaticHookDefinition> getBeforeAllHooks() {
        return new ArrayList<StaticHookDefinition>(this.beforeAllHooks);
    }

    Collection<CoreHookDefinition> getBeforeHooks() {
        return new ArrayList<CoreHookDefinition>(this.beforeHooks);
    }

    Collection<CoreHookDefinition> getBeforeStepHooks() {
        return new ArrayList<CoreHookDefinition>(this.beforeStepHooks);
    }

    Collection<CoreHookDefinition> getAfterHooks() {
        ArrayList<CoreHookDefinition> hooks = new ArrayList<CoreHookDefinition>(this.afterHooks);
        Collections.reverse(hooks);
        return hooks;
    }

    Collection<CoreHookDefinition> getAfterStepHooks() {
        ArrayList<CoreHookDefinition> hooks = new ArrayList<CoreHookDefinition>(this.afterStepHooks);
        Collections.reverse(hooks);
        return hooks;
    }

    List<StaticHookDefinition> getAfterAllHooks() {
        ArrayList<StaticHookDefinition> hooks = new ArrayList<StaticHookDefinition>(this.afterAllHooks);
        Collections.reverse(hooks);
        return hooks;
    }

    Collection<ParameterTypeDefinition> getParameterTypeDefinitions() {
        return this.parameterTypeDefinitions;
    }

    Collection<DataTableTypeDefinition> getDataTableTypeDefinitions() {
        return this.dataTableTypeDefinitions;
    }

    Collection<io.cucumber.core.backend.StepDefinition> getStepDefinitions() {
        return this.stepDefinitions;
    }

    Map<String, String> getStepPatternByStepText() {
        return this.stepPatternByStepText;
    }

    Map<String, CoreStepDefinition> getStepDefinitionsByPattern() {
        return this.stepDefinitionsByPattern;
    }

    Collection<DefaultParameterTransformerDefinition> getDefaultParameterTransformers() {
        return this.defaultParameterTransformers;
    }

    Collection<CoreDefaultDataTableEntryTransformerDefinition> getDefaultDataTableEntryTransformers() {
        return this.defaultDataTableEntryTransformers;
    }

    Collection<DefaultDataTableCellTransformerDefinition> getDefaultDataTableCellTransformers() {
        return this.defaultDataTableCellTransformers;
    }

    List<DocStringTypeDefinition> getDocStringTypeDefinitions() {
        return this.docStringTypeDefinitions;
    }

    void prepareGlue(StepTypeRegistry stepTypeRegistry) throws DuplicateStepDefinitionException {
        ParameterByTypeTransformer transformer;
        Located definition;
        StepExpressionFactory stepExpressionFactory = new StepExpressionFactory(stepTypeRegistry, this.bus);
        this.parameterTypeDefinitions.forEach(ptd -> {
            io.cucumber.cucumberexpressions.ParameterType<?> parameterType = ptd.parameterType();
            stepTypeRegistry.defineParameterType(parameterType);
            this.emitParameterTypeDefined((ParameterTypeDefinition)ptd);
        });
        this.dataTableTypeDefinitions.forEach(dtd -> stepTypeRegistry.defineDataTableType(dtd.dataTableType()));
        this.docStringTypeDefinitions.forEach(dtd -> stepTypeRegistry.defineDocStringType(dtd.docStringType()));
        if (this.defaultParameterTransformers.size() == 1) {
            definition = this.defaultParameterTransformers.get(0);
            transformer = definition.parameterByTypeTransformer();
            stepTypeRegistry.setDefaultParameterTransformer(transformer);
        } else if (this.defaultParameterTransformers.size() > 1) {
            throw new DuplicateDefaultParameterTransformers(this.defaultParameterTransformers);
        }
        if (this.defaultDataTableEntryTransformers.size() == 1) {
            definition = this.defaultDataTableEntryTransformers.get(0);
            transformer = definition.tableEntryByTypeTransformer();
            stepTypeRegistry.setDefaultDataTableEntryTransformer((TableEntryByTypeTransformer)transformer);
        } else if (this.defaultDataTableEntryTransformers.size() > 1) {
            throw new DuplicateDefaultDataTableEntryTransformers(this.defaultDataTableEntryTransformers);
        }
        if (this.defaultDataTableCellTransformers.size() == 1) {
            definition = this.defaultDataTableCellTransformers.get(0);
            transformer = definition.tableCellByTypeTransformer();
            stepTypeRegistry.setDefaultDataTableCellTransformer((TableCellByTypeTransformer)transformer);
        } else if (this.defaultDataTableCellTransformers.size() > 1) {
            throw new DuplicateDefaultDataTableCellTransformers(this.defaultDataTableCellTransformers);
        }
        this.beforeHooks.forEach(this::emitHook);
        this.beforeStepHooks.forEach(this::emitHook);
        this.stepDefinitions.forEach(stepDefinition -> {
            StepExpression expression = stepExpressionFactory.createExpression((io.cucumber.core.backend.StepDefinition)stepDefinition);
            CoreStepDefinition coreStepDefinition = new CoreStepDefinition(this.bus.generateId(), (io.cucumber.core.backend.StepDefinition)stepDefinition, expression);
            CoreStepDefinition previous = this.stepDefinitionsByPattern.get(stepDefinition.getPattern());
            if (previous != null) {
                throw new DuplicateStepDefinitionException(previous, (io.cucumber.core.backend.StepDefinition)stepDefinition);
            }
            this.stepDefinitionsByPattern.put(coreStepDefinition.getExpression().getSource(), coreStepDefinition);
            this.emitStepDefined(coreStepDefinition);
        });
        this.afterStepHooks.forEach(this::emitHook);
        this.afterHooks.forEach(this::emitHook);
    }

    private void emitParameterTypeDefined(ParameterTypeDefinition parameterTypeDefinition) {
        io.cucumber.cucumberexpressions.ParameterType<?> parameterType = parameterTypeDefinition.parameterType();
        ParameterType messagesParameterType = new ParameterType(parameterType.getName(), parameterType.getRegexps(), Boolean.valueOf(parameterType.preferForRegexpMatch()), Boolean.valueOf(parameterType.useForSnippets()), this.bus.generateId().toString(), parameterTypeDefinition.getSourceReference().map(this::createSourceReference).orElseGet(this::emptySourceReference));
        this.bus.send(Envelope.of((ParameterType)messagesParameterType));
    }

    private void emitHook(CoreHookDefinition coreHook) {
        Hook messagesHook = new Hook(coreHook.getId().toString(), null, coreHook.getDefinitionLocation().map(this::createSourceReference).orElseGet(this::emptySourceReference), coreHook.getTagExpression(), (HookType)coreHook.getHookType().map(hookType -> {
            switch (hookType) {
                case BEFORE: {
                    return HookType.BEFORE_TEST_CASE;
                }
                case AFTER: {
                    return HookType.AFTER_TEST_CASE;
                }
                case BEFORE_STEP: {
                    return HookType.BEFORE_TEST_STEP;
                }
                case AFTER_STEP: {
                    return HookType.AFTER_TEST_STEP;
                }
            }
            return null;
        }).orElse(null));
        this.bus.send(Envelope.of((Hook)messagesHook));
    }

    private void emitStepDefined(CoreStepDefinition coreStepDefinition) {
        this.bus.send(new StepDefinedEvent(this.bus.getInstant(), new StepDefinition(coreStepDefinition.getStepDefinition().getLocation(), coreStepDefinition.getExpression().getSource())));
        io.cucumber.messages.types.StepDefinition messagesStepDefinition = new io.cucumber.messages.types.StepDefinition(coreStepDefinition.getId().toString(), new StepDefinitionPattern(coreStepDefinition.getExpression().getSource(), this.getExpressionType(coreStepDefinition)), coreStepDefinition.getDefinitionLocation().map(this::createSourceReference).orElseGet(this::emptySourceReference));
        this.bus.send(Envelope.of((io.cucumber.messages.types.StepDefinition)messagesStepDefinition));
    }

    private io.cucumber.messages.types.SourceReference createSourceReference(SourceReference reference) {
        if (reference instanceof JavaMethodReference) {
            JavaMethodReference methodReference = (JavaMethodReference)reference;
            return io.cucumber.messages.types.SourceReference.of((JavaMethod)new JavaMethod(methodReference.className(), methodReference.methodName(), methodReference.methodParameterTypes()));
        }
        if (reference instanceof StackTraceElementReference) {
            StackTraceElementReference stackReference = (StackTraceElementReference)reference;
            JavaStackTraceElement stackTraceElement = new JavaStackTraceElement(stackReference.className(), stackReference.fileName().orElse("Unknown"), stackReference.methodName());
            Location location = new Location(Long.valueOf(stackReference.lineNumber()), null);
            return new io.cucumber.messages.types.SourceReference(null, null, stackTraceElement, location);
        }
        return this.emptySourceReference();
    }

    private io.cucumber.messages.types.SourceReference emptySourceReference() {
        return new io.cucumber.messages.types.SourceReference(null, null, null, null);
    }

    private StepDefinitionPatternType getExpressionType(CoreStepDefinition stepDefinition) {
        Class<? extends Expression> expressionType = stepDefinition.getExpression().getExpressionType();
        if (expressionType.isAssignableFrom(RegularExpression.class)) {
            return StepDefinitionPatternType.REGULAR_EXPRESSION;
        }
        if (expressionType.isAssignableFrom(CucumberExpression.class)) {
            return StepDefinitionPatternType.CUCUMBER_EXPRESSION;
        }
        throw new IllegalArgumentException(expressionType.getName());
    }

    PickleStepDefinitionMatch stepDefinitionMatch(URI uri, Step step) throws AmbiguousStepDefinitionsException {
        PickleStepDefinitionMatch cachedMatch = this.cachedStepDefinitionMatch(uri, step);
        if (cachedMatch != null) {
            return cachedMatch;
        }
        return this.findStepDefinitionMatch(uri, step);
    }

    private PickleStepDefinitionMatch cachedStepDefinitionMatch(URI uri, Step step) {
        String stepDefinitionPattern = this.stepPatternByStepText.get(step.getText());
        if (stepDefinitionPattern == null) {
            return null;
        }
        CoreStepDefinition coreStepDefinition = this.stepDefinitionsByPattern.get(stepDefinitionPattern);
        if (coreStepDefinition == null) {
            return null;
        }
        List<Argument> arguments = coreStepDefinition.matchedArguments(step);
        return new PickleStepDefinitionMatch(arguments, coreStepDefinition, uri, step);
    }

    private PickleStepDefinitionMatch findStepDefinitionMatch(URI uri, Step step) throws AmbiguousStepDefinitionsException {
        List<PickleStepDefinitionMatch> matches = this.stepDefinitionMatches(uri, step);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            throw new AmbiguousStepDefinitionsException(step, matches);
        }
        PickleStepDefinitionMatch match = matches.get(0);
        this.stepPatternByStepText.put(step.getText(), match.getPattern());
        return match;
    }

    private List<PickleStepDefinitionMatch> stepDefinitionMatches(URI uri, Step step) {
        ArrayList<PickleStepDefinitionMatch> result = new ArrayList<PickleStepDefinitionMatch>();
        for (CoreStepDefinition coreStepDefinition : this.stepDefinitionsByPattern.values()) {
            List<Argument> arguments = coreStepDefinition.matchedArguments(step);
            if (arguments == null) continue;
            result.add(new PickleStepDefinitionMatch(arguments, coreStepDefinition, uri, step));
        }
        return result;
    }

    void removeScenarioScopedGlue() {
        this.stepDefinitionsByPattern.clear();
        this.removeScenarioScopedGlue(this.beforeHooks);
        this.removeScenarioScopedGlue(this.beforeStepHooks);
        this.removeScenarioScopedGlue(this.afterHooks);
        this.removeScenarioScopedGlue(this.afterStepHooks);
        this.removeScenarioScopedGlue(this.stepDefinitions);
        this.removeScenarioScopedGlue(this.dataTableTypeDefinitions);
        this.removeScenarioScopedGlue(this.docStringTypeDefinitions);
        this.removeScenarioScopedGlue(this.parameterTypeDefinitions);
        this.removeScenarioScopedGlue(this.defaultParameterTransformers);
        this.removeScenarioScopedGlue(this.defaultDataTableEntryTransformers);
        this.removeScenarioScopedGlue(this.defaultDataTableCellTransformers);
    }

    private void removeScenarioScopedGlue(Iterable<?> glues) {
        Iterator<?> glueIterator = glues.iterator();
        while (glueIterator.hasNext()) {
            Object glue = glueIterator.next();
            if (!(glue instanceof ScenarioScoped)) continue;
            ScenarioScoped scenarioScoped = (ScenarioScoped)glue;
            scenarioScoped.dispose();
            glueIterator.remove();
        }
    }
}

