/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.exception.ExceptionUtils;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceParsed;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import java.io.PrintStream;
import java.net.URI;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TeamCityPlugin
implements EventListener {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private static final String TEAMCITY_PREFIX = "##teamcity";
    private static final String TEMPLATE_ENTER_THE_MATRIX = "##teamcity[enteredTheMatrix timestamp = '%s']";
    private static final String TEMPLATE_TEST_RUN_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' name = 'Cucumber']";
    private static final String TEMPLATE_TEST_RUN_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = 'Cucumber']";
    private static final String TEMPLATE_TEST_SUITE_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' locationHint = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_SUITE_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_STARTED = "##teamcity[testStarted timestamp = '%s' locationHint = '%s' captureStandardOutput = 'true' name = '%s']";
    private static final String TEMPLATE_TEST_FINISHED = "##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_FAILED = "##teamcity[testFailed timestamp = '%s' duration = '%s' message = '%s' details = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_COMPARISON_FAILED = "##teamcity[testFailed timestamp = '%s' duration = '%s' message = '%s' details = '%s' expected = '%s' actual = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_IGNORED = "##teamcity[testIgnored timestamp = '%s' duration = '%s' message = '%s' name = '%s']";
    private static final String TEMPLATE_BEFORE_ALL_AFTER_ALL_STARTED = "##teamcity[testStarted timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_BEFORE_ALL_AFTER_ALL_FAILED = "##teamcity[testFailed timestamp = '%s' message = '%s' details = '%s' name = '%s']";
    private static final String TEMPLATE_BEFORE_ALL_AFTER_ALL_FINISHED = "##teamcity[testFinished timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_PROGRESS_COUNTING_STARTED = "##teamcity[customProgressStatus testsCategory = 'Scenarios' count = '0' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_COUNTING_FINISHED = "##teamcity[customProgressStatus testsCategory = '' count = '0' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_TEST_STARTED = "##teamcity[customProgressStatus type = 'testStarted' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_TEST_FINISHED = "##teamcity[customProgressStatus type = 'testFinished' timestamp = '%s']";
    private static final String TEMPLATE_ATTACH_WRITE_EVENT = "##teamcity[message text='%s' status='NORMAL']";
    private static final Pattern ANNOTATION_GLUE_CODE_LOCATION_PATTERN = Pattern.compile("^(.*)\\.(.*)\\([^:]*\\)");
    private static final Pattern LAMBDA_GLUE_CODE_LOCATION_PATTERN = Pattern.compile("^(.*)\\.(.*)\\(.*:.*\\)");
    private static final Pattern[] COMPARE_PATTERNS = new Pattern[]{Pattern.compile("expected: (.*)(?:\r\n|\r|\n) {5}but: was (.*)$", 34), Pattern.compile("expected: (.*)(?:\r\n|\r|\n) but was: (.*)$", 34), Pattern.compile("expected: <(.*)> but was: <(.*)>$", 34), Pattern.compile("expected:\\s?<(.*)> but was:\\s?<(.*)>$", 34), Pattern.compile("expected \\[(.*)] but found \\[(.*)]\n$", 34)};
    private final PrintStream out;
    private final List<SnippetsSuggestedEvent> suggestions = new ArrayList<SnippetsSuggestedEvent>();
    private final Map<URI, Collection<Node>> parsedTestSources = new HashMap<URI, Collection<Node>>();
    private List<Node> currentStack = new ArrayList<Node>();
    private TestCase currentTestCase;

    public TeamCityPlugin() {
        this(System.out);
    }

    TeamCityPlugin(PrintStream out) {
        this.out = out;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this::printTestRunStarted);
        publisher.registerHandlerFor(TestCaseStarted.class, this::printTestCaseStarted);
        publisher.registerHandlerFor(TestStepStarted.class, this::printTestStepStarted);
        publisher.registerHandlerFor(TestStepFinished.class, this::printTestStepFinished);
        publisher.registerHandlerFor(TestCaseFinished.class, this::printTestCaseFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::printTestRunFinished);
        publisher.registerHandlerFor(SnippetsSuggestedEvent.class, this::handleSnippetSuggested);
        publisher.registerHandlerFor(EmbedEvent.class, this::handleEmbedEvent);
        publisher.registerHandlerFor(WriteEvent.class, this::handleWriteEvent);
        publisher.registerHandlerFor(TestSourceParsed.class, this::handleTestSourceParsed);
    }

    private void handleTestSourceParsed(TestSourceParsed event) {
        this.parsedTestSources.put(event.getUri(), event.getNodes());
    }

    private void printTestRunStarted(TestRunStarted event) {
        String timestamp = this.extractTimeStamp((Event)event);
        this.print(TEMPLATE_ENTER_THE_MATRIX, timestamp);
        this.print(TEMPLATE_TEST_RUN_STARTED, timestamp);
        this.print(TEMPLATE_PROGRESS_COUNTING_STARTED, timestamp);
    }

    private String extractTimeStamp(Event event) {
        ZonedDateTime date = event.getInstant().atZone(ZoneOffset.UTC);
        return DATE_FORMAT.format(date);
    }

    private void printTestCaseStarted(TestCaseStarted event) {
        TestCase testCase = event.getTestCase();
        URI uri = testCase.getUri();
        String timestamp = this.extractTimeStamp((Event)event);
        Location location = testCase.getLocation();
        Predicate<Node> withLocation = candidate -> location.equals((Object)candidate.getLocation());
        List<Node> path = this.parsedTestSources.get(uri).stream().map(node -> node.findPathTo(withLocation)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(Collections.emptyList());
        this.poppedNodes(path).forEach(node -> this.finishNode(timestamp, (Node)node));
        this.pushedNodes(path).forEach(node -> this.startNode(uri, timestamp, (Node)node));
        this.currentStack = path;
        this.currentTestCase = testCase;
        this.print(TEMPLATE_PROGRESS_TEST_STARTED, timestamp);
    }

    private void startNode(URI uri, String timestamp, Node node) {
        Supplier<String> keyword = () -> node.getKeyword().orElse("Unknown");
        String name = node.getName().orElseGet(keyword);
        String location = uri + ":" + node.getLocation().getLine();
        this.print(TEMPLATE_TEST_SUITE_STARTED, timestamp, location, name);
    }

    private void finishNode(String timestamp, Node node) {
        Supplier<String> keyword = () -> node.getKeyword().orElse("Unknown");
        String name = node.getName().orElseGet(keyword);
        this.print(TEMPLATE_TEST_SUITE_FINISHED, timestamp, name);
    }

    private List<Node> poppedNodes(List<Node> newStack) {
        ArrayList<Node> nodes = new ArrayList<Node>(this.reversedPoppedNodes(this.currentStack, newStack));
        Collections.reverse(nodes);
        return nodes;
    }

    private List<Node> reversedPoppedNodes(List<Node> currentStack, List<Node> newStack) {
        for (int i = 0; i < currentStack.size() && i < newStack.size(); ++i) {
            if (currentStack.get(i).equals(newStack.get(i))) continue;
            return currentStack.subList(i, currentStack.size());
        }
        if (newStack.size() < currentStack.size()) {
            return currentStack.subList(newStack.size(), currentStack.size());
        }
        return Collections.emptyList();
    }

    private List<Node> pushedNodes(List<Node> newStack) {
        for (int i = 0; i < this.currentStack.size() && i < newStack.size(); ++i) {
            if (this.currentStack.get(i).equals(newStack.get(i))) continue;
            return newStack.subList(i, newStack.size());
        }
        if (newStack.size() < this.currentStack.size()) {
            return Collections.emptyList();
        }
        return newStack.subList(this.currentStack.size(), newStack.size());
    }

    private void printTestStepStarted(TestStepStarted event) {
        String timestamp = this.extractTimeStamp((Event)event);
        String name = this.extractName(event.getTestStep());
        String location = this.extractLocation(event);
        this.print(TEMPLATE_TEST_STARTED, timestamp, location, name);
    }

    private String extractLocation(TestStepStarted event) {
        TestStep testStep = event.getTestStep();
        if (testStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
            return pickleStepTestStep.getUri() + ":" + pickleStepTestStep.getStep().getLine();
        }
        if (testStep instanceof HookTestStep) {
            return this.formatHookStepLocation((HookTestStep)testStep, TeamCityPlugin.javaTestLocationUri(), TestStep::getCodeLocation);
        }
        return testStep.getCodeLocation();
    }

    private static BiFunction<String, String, String> javaTestLocationUri() {
        return (fqDeclaringClassName, classOrMethodName) -> String.format("java:test://%s/%s", fqDeclaringClassName, classOrMethodName);
    }

    private String formatHookStepLocation(HookTestStep hookTestStep, BiFunction<String, String, String> hookStepCase, Function<HookTestStep, String> defaultHookName) {
        Matcher javaMatcher = ANNOTATION_GLUE_CODE_LOCATION_PATTERN.matcher(hookTestStep.getCodeLocation());
        if (javaMatcher.matches()) {
            String fqDeclaringClassName = javaMatcher.group(1);
            String methodName = javaMatcher.group(2);
            return hookStepCase.apply(fqDeclaringClassName, methodName);
        }
        Matcher java8Matcher = LAMBDA_GLUE_CODE_LOCATION_PATTERN.matcher(hookTestStep.getCodeLocation());
        if (java8Matcher.matches()) {
            String fqDeclaringClassName = java8Matcher.group(1);
            int indexOfPackageSeparator = fqDeclaringClassName.lastIndexOf(".");
            String declaringClassName = indexOfPackageSeparator != -1 ? fqDeclaringClassName.substring(indexOfPackageSeparator + 1) : fqDeclaringClassName;
            return hookStepCase.apply(fqDeclaringClassName, declaringClassName);
        }
        return defaultHookName.apply(hookTestStep);
    }

    private void printTestStepFinished(TestStepFinished event) {
        String timeStamp = this.extractTimeStamp((Event)event);
        long duration = this.extractDuration(event.getResult());
        String name = this.extractName(event.getTestStep());
        Throwable error = event.getResult().getError();
        Status status = event.getResult().getStatus();
        switch (status) {
            case SKIPPED: {
                String message = error == null ? "Step skipped" : error.getMessage();
                this.print(TEMPLATE_TEST_IGNORED, timeStamp, duration, message, name);
                break;
            }
            case PENDING: {
                String details = error == null ? "" : error.getMessage();
                this.print(TEMPLATE_TEST_FAILED, timeStamp, duration, "Step pending", details, name);
                break;
            }
            case UNDEFINED: {
                String snippets = this.getSnippets(this.currentTestCase);
                this.print(TEMPLATE_TEST_FAILED, timeStamp, duration, "Step undefined", snippets, name);
                break;
            }
            case AMBIGUOUS: 
            case FAILED: {
                String details = ExceptionUtils.printStackTrace(error);
                String message = error.getMessage();
                if (message == null) {
                    this.print(TEMPLATE_TEST_FAILED, timeStamp, duration, "Step failed", details, name);
                    break;
                }
                ComparisonFailure comparisonFailure = ComparisonFailure.parse(message.trim());
                if (comparisonFailure == null) {
                    this.print(TEMPLATE_TEST_FAILED, timeStamp, duration, "Step failed", details, name);
                    break;
                }
                this.print(TEMPLATE_TEST_COMPARISON_FAILED, timeStamp, duration, "Step failed", details, comparisonFailure.getExpected(), comparisonFailure.getActual(), name);
                break;
            }
        }
        this.print(TEMPLATE_TEST_FINISHED, timeStamp, duration, name);
    }

    private String getHookName(HookTestStep hook) {
        HookType hookType = hook.getHookType();
        switch (hookType) {
            case BEFORE: {
                return "Before";
            }
            case AFTER: {
                return "After";
            }
            case BEFORE_STEP: {
                return "BeforeStep";
            }
            case AFTER_STEP: {
                return "AfterStep";
            }
        }
        return hookType.name().toLowerCase(Locale.US);
    }

    private String extractName(TestStep testStep) {
        if (testStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
            return pickleStepTestStep.getStep().getText();
        }
        if (testStep instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)testStep;
            return this.formatHookStepLocation(hookTestStep, this.hookNameFormat(hookTestStep), this::getHookName);
        }
        return "Unknown step";
    }

    private BiFunction<String, String, String> hookNameFormat(HookTestStep hookTestStep) {
        return (fqDeclaringClassName, classOrMethodName) -> String.format("%s(%s)", this.getHookName(hookTestStep), classOrMethodName);
    }

    private String getSnippets(TestCase testCase) {
        URI uri = testCase.getUri();
        Location location = testCase.getLocation();
        List<SnippetsSuggestedEvent.Suggestion> suggestionForTestCase = this.suggestions.stream().filter(suggestion -> suggestion.getUri().equals(uri) && suggestion.getTestCaseLocation().equals((Object)location)).map(SnippetsSuggestedEvent::getSuggestion).collect(Collectors.toList());
        return TeamCityPlugin.createMessage(suggestionForTestCase);
    }

    private static String createMessage(Collection<SnippetsSuggestedEvent.Suggestion> suggestions) {
        if (suggestions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("You can implement this step");
        if (suggestions.size() > 1) {
            sb.append(" and ").append(suggestions.size() - 1).append(" other step(s)");
        }
        sb.append(" using the snippet(s) below:\n\n");
        String snippets = suggestions.stream().map(SnippetsSuggestedEvent.Suggestion::getSnippets).flatMap(Collection::stream).distinct().collect(Collectors.joining("\n", "", "\n"));
        sb.append(snippets);
        return sb.toString();
    }

    private void printTestCaseFinished(TestCaseFinished event) {
        String timestamp = this.extractTimeStamp((Event)event);
        this.print(TEMPLATE_PROGRESS_TEST_FINISHED, timestamp);
        this.finishNode(timestamp, this.currentStack.remove(this.currentStack.size() - 1));
        this.currentTestCase = null;
    }

    private long extractDuration(Result result) {
        return result.getDuration().toMillis();
    }

    private void printTestRunFinished(TestRunFinished event) {
        String timestamp = this.extractTimeStamp((Event)event);
        this.print(TEMPLATE_PROGRESS_COUNTING_FINISHED, timestamp);
        ArrayList<Node> emptyStack = new ArrayList<Node>();
        this.poppedNodes(emptyStack).forEach(node -> this.finishNode(timestamp, (Node)node));
        this.currentStack = emptyStack;
        this.printBeforeAfterAllResult(event, timestamp);
        this.print(TEMPLATE_TEST_RUN_FINISHED, timestamp);
    }

    private void printBeforeAfterAllResult(TestRunFinished event, String timestamp) {
        Throwable error = event.getResult().getError();
        if (error == null) {
            return;
        }
        String name = "Before All/After All";
        this.print(TEMPLATE_BEFORE_ALL_AFTER_ALL_STARTED, timestamp, name);
        String details = ExceptionUtils.printStackTrace(error);
        this.print(TEMPLATE_BEFORE_ALL_AFTER_ALL_FAILED, timestamp, "Before All/After All failed", details, name);
        this.print(TEMPLATE_BEFORE_ALL_AFTER_ALL_FINISHED, timestamp, name);
    }

    private void handleSnippetSuggested(SnippetsSuggestedEvent event) {
        this.suggestions.add(event);
    }

    private void handleEmbedEvent(EmbedEvent event) {
        String name = event.getName() == null ? "" : event.getName() + " ";
        this.print(TEMPLATE_ATTACH_WRITE_EVENT, "Embed event: " + name + "[" + event.getMediaType() + " " + event.getData().length + " bytes]\n");
    }

    private void handleWriteEvent(WriteEvent event) {
        this.print(TEMPLATE_ATTACH_WRITE_EVENT, "Write event:\n" + event.getText() + "\n");
    }

    private void print(String command, Object ... args) {
        this.out.println(this.formatCommand(command, args));
    }

    private String formatCommand(String command, Object ... parameters) {
        String[] escapedParameters = new String[parameters.length];
        for (int i = 0; i < escapedParameters.length; ++i) {
            escapedParameters[i] = this.escape(parameters[i].toString());
        }
        return String.format(command, escapedParameters);
    }

    private String escape(String source) {
        if (source == null) {
            return "";
        }
        return source.replace("|", "||").replace("'", "|'").replace("\n", "|n").replace("\r", "|r").replace("[", "|[").replace("]", "|]");
    }

    private static class ComparisonFailure {
        private final String expected;
        private final String actual;

        static ComparisonFailure parse(String message) {
            for (Pattern pattern : COMPARE_PATTERNS) {
                ComparisonFailure result = ComparisonFailure.parse(message, pattern);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        static ComparisonFailure parse(String message, Pattern pattern) {
            Matcher matcher = pattern.matcher(message);
            if (!matcher.find()) {
                return null;
            }
            String expected = matcher.group(1);
            String actual = matcher.group(2);
            return new ComparisonFailure(expected, actual);
        }

        ComparisonFailure(String expected, String actual) {
            this.expected = Objects.requireNonNull(expected);
            this.actual = Objects.requireNonNull(actual);
        }

        public String getExpected() {
            return this.expected;
        }

        public String getActual() {
            return this.actual;
        }
    }
}

