/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.AnsiEscapes;
import io.cucumber.core.plugin.Banner;
import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import java.io.PrintStream;
import java.util.Arrays;

public final class NoPublishFormatter
implements ConcurrentEventListener,
ColorAware {
    private final PrintStream out;
    private boolean monochrome = false;

    public NoPublishFormatter() {
        this(System.err);
    }

    NoPublishFormatter(PrintStream out) {
        this.out = out;
    }

    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::writeMessage);
    }

    private void writeMessage(Envelope envelope) {
        if (envelope.getTestRunFinished().isPresent()) {
            this.printBanner();
        }
    }

    private void printBanner() {
        Banner banner = new Banner(this.out, this.monochrome);
        banner.print(Arrays.asList(new Banner.Line(new Banner.Span("Share your Cucumber Report with your team at "), new Banner.Span("https://reports.cucumber.io", AnsiEscapes.CYAN, AnsiEscapes.INTENSITY_BOLD, AnsiEscapes.UNDERLINE)), new Banner.Line("Activate publishing with one of the following:", new AnsiEscapes[0]), new Banner.Line("", new AnsiEscapes[0]), new Banner.Line(new Banner.Span("src/test/resources/cucumber.properties:          "), new Banner.Span("cucumber.publish.enabled", AnsiEscapes.CYAN), new Banner.Span("="), new Banner.Span("true", AnsiEscapes.CYAN)), new Banner.Line(new Banner.Span("src/test/resources/junit-platform.properties:    "), new Banner.Span("cucumber.publish.enabled", AnsiEscapes.CYAN), new Banner.Span("="), new Banner.Span("true", AnsiEscapes.CYAN)), new Banner.Line(new Banner.Span("Environment variable:                            "), new Banner.Span("cucumber.publish.enabled".toUpperCase().replace('.', '_'), AnsiEscapes.CYAN), new Banner.Span("="), new Banner.Span("true", AnsiEscapes.CYAN)), new Banner.Line(new Banner.Span("JUnit:                                           "), new Banner.Span("@CucumberOptions", AnsiEscapes.CYAN), new Banner.Span("(publish = "), new Banner.Span("true", AnsiEscapes.CYAN), new Banner.Span(")")), new Banner.Line("", new AnsiEscapes[0]), new Banner.Line(new Banner.Span("More information at "), new Banner.Span("https://cucumber.io/docs/cucumber/environment-variables/", AnsiEscapes.CYAN)), new Banner.Line("", new AnsiEscapes[0]), new Banner.Line(new Banner.Span("Disable this message with one of the following:")), new Banner.Line("", new AnsiEscapes[0]), new Banner.Line(new Banner.Span("src/test/resources/cucumber.properties:          "), new Banner.Span("cucumber.publish.quiet", AnsiEscapes.CYAN), new Banner.Span("="), new Banner.Span("true", AnsiEscapes.CYAN)), new Banner.Line(new Banner.Span("src/test/resources/junit-platform.properties:    "), new Banner.Span("cucumber.publish.quiet", AnsiEscapes.CYAN), new Banner.Span("="), new Banner.Span("true", AnsiEscapes.CYAN))), AnsiEscapes.GREEN, AnsiEscapes.INTENSITY_BOLD);
    }
}

