/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.FeatureWithLinesOrRerunPath;
import io.cucumber.core.options.ObjectFactoryParser;
import io.cucumber.core.options.PickleOrderParser;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.options.SnippetTypeParser;
import io.cucumber.core.options.UuidGeneratorParser;
import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableFormatter;
import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinDialectProvider;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CommandlineOptionsParser {
    private static final Logger log = LoggerFactory.getLogger(CommandlineOptionsParser.class);
    private static final String CORE_VERSION = ResourceBundle.getBundle("io.cucumber.core.version").getString("cucumber-jvm.version");
    private static final String USAGE_RESOURCE = "/io/cucumber/core/options/USAGE.txt";
    private final PrintWriter out;
    private Byte exitCode = null;

    public CommandlineOptionsParser(OutputStream outputStream) {
        this.out = new PrintWriter(outputStream, true);
    }

    public Optional<Byte> exitStatus() {
        return Optional.ofNullable(this.exitCode);
    }

    public RuntimeOptionsBuilder parse(String ... args) {
        return this.parse(Arrays.asList(args));
    }

    private RuntimeOptionsBuilder parse(List<String> args) {
        args = new ArrayList<String>(args);
        RuntimeOptionsBuilder parsedOptions = new RuntimeOptionsBuilder();
        while (!args.isEmpty()) {
            String arg = args.remove(0).trim();
            if (arg.equals("--help") || arg.equals("-h")) {
                this.printUsage();
                this.exitCode = 0;
                return parsedOptions;
            }
            if (arg.equals("--version") || arg.equals("-v")) {
                this.out.println(CORE_VERSION);
                this.exitCode = 0;
                return parsedOptions;
            }
            if (arg.equals("--i18n")) {
                String nextArg = this.removeArgFor(arg, args);
                this.exitCode = this.printI18n(nextArg);
                return parsedOptions;
            }
            if (arg.equals("--threads")) {
                int threads = Integer.parseInt(this.removeArgFor(arg, args));
                if (threads < 1) {
                    this.out.println("--threads must be > 0");
                    this.exitCode = 1;
                    return parsedOptions;
                }
                parsedOptions.setThreads(threads);
                continue;
            }
            if (arg.equals("--glue") || arg.equals("-g")) {
                String gluePath = this.removeArgFor(arg, args);
                URI parse = GluePath.parse(gluePath);
                parsedOptions.addGlue(parse);
                continue;
            }
            if (arg.equals("--tags") || arg.equals("-t")) {
                parsedOptions.addTagFilter(TagExpressionParser.parse((String)this.removeArgFor(arg, args)));
                continue;
            }
            if (arg.equals("--publish")) {
                parsedOptions.setPublish(true);
                continue;
            }
            if (arg.equals("--plugin") || arg.equals("-p")) {
                String pluginName = this.removeArgFor(arg, args);
                if (pluginName.equals("null_summary")) {
                    log.warn(() -> "Use '--no-summary' instead of '-p/--plugin null_summary'. '-p/--plugin null_summary' will be removed in a future release.");
                    parsedOptions.setNoSummary();
                    continue;
                }
                if (pluginName.equals("default_summary")) {
                    log.warn(() -> "Use '-p/--plugin summary' instead of '-p/--plugin default_summary'. '-p/--plugin default_summary' will be removed in a future release.");
                    parsedOptions.addPluginName("summary");
                    continue;
                }
                parsedOptions.addPluginName(pluginName);
                continue;
            }
            if (arg.equals("--dry-run") || arg.equals("-d")) {
                parsedOptions.setDryRun(true);
                continue;
            }
            if (arg.equals("--no-dry-run")) {
                parsedOptions.setDryRun(false);
                continue;
            }
            if (arg.equals("--no-summary")) {
                parsedOptions.setNoSummary();
                continue;
            }
            if (arg.equals("--monochrome") || arg.equals("-m")) {
                parsedOptions.setMonochrome(true);
                continue;
            }
            if (arg.equals("--no-monochrome")) {
                parsedOptions.setMonochrome(false);
                continue;
            }
            if (arg.equals("--snippets")) {
                String nextArg = this.removeArgFor(arg, args);
                parsedOptions.setSnippetType(SnippetTypeParser.parseSnippetType(nextArg));
                continue;
            }
            if (arg.equals("--name") || arg.equals("-n")) {
                String nextArg = this.removeArgFor(arg, args);
                Pattern pattern = Pattern.compile(nextArg);
                parsedOptions.addNameFilter(pattern);
                continue;
            }
            if (arg.equals("--wip") || arg.equals("-w")) {
                parsedOptions.setWip(true);
                continue;
            }
            if (arg.equals("--order")) {
                parsedOptions.setPickleOrder(PickleOrderParser.parse(this.removeArgFor(arg, args)));
                continue;
            }
            if (arg.equals("--count")) {
                int count = Integer.parseInt(this.removeArgFor(arg, args));
                if (count < 1) {
                    this.out.println("--count must be > 0");
                    this.exitCode = 1;
                    return parsedOptions;
                }
                parsedOptions.setCount(count);
                continue;
            }
            if (arg.equals("--object-factory")) {
                String objectFactoryClassName = this.removeArgFor(arg, args);
                parsedOptions.setObjectFactoryClass(ObjectFactoryParser.parseObjectFactory(objectFactoryClassName));
                continue;
            }
            if (arg.equals("--uuid-generator")) {
                String uuidGeneratorClassName = this.removeArgFor(arg, args);
                parsedOptions.setUuidGeneratorClass(UuidGeneratorParser.parseUuidGenerator(uuidGeneratorClassName));
                continue;
            }
            if (arg.startsWith("-")) {
                this.out.println("Unknown option: " + arg);
                this.printUsage();
                this.exitCode = 1;
                return parsedOptions;
            }
            if (arg.isEmpty()) continue;
            FeatureWithLinesOrRerunPath parsed = FeatureWithLinesOrRerunPath.parse(arg);
            parsed.getFeaturesToRerun().ifPresent(parsedOptions::addRerun);
            parsed.getFeatureWithLines().ifPresent(parsedOptions::addFeature);
        }
        return parsedOptions;
    }

    private void printUsage() {
        this.out.println(this.loadUsageText());
    }

    private String removeArgFor(String arg, List<String> args) {
        if (!args.isEmpty()) {
            return args.remove(0);
        }
        this.printUsage();
        throw new CucumberException("Missing argument for " + arg);
    }

    private byte printI18n(String language) {
        GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
        Set languages = dialectProvider.getLanguages();
        if (language.equalsIgnoreCase("help") && language.equalsIgnoreCase("help")) {
            List<GherkinDialect> dialects = languages.stream().map(arg_0 -> ((GherkinDialectProvider)dialectProvider).getDialect(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            int widestLanguage = this.findWidest(dialects, GherkinDialect::getLanguage);
            int widestName = this.findWidest(dialects, GherkinDialect::getName);
            int widestNativeName = this.findWidest(dialects, GherkinDialect::getNativeName);
            for (GherkinDialect dialect : dialects) {
                this.printDialect(dialect, widestLanguage, widestName, widestNativeName);
            }
            return 0;
        }
        if (languages.contains(language)) {
            dialectProvider.getDialect(language).ifPresent(this::printKeywordsFor);
        }
        this.out.println("Unrecognised ISO language code");
        return 1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String loadUsageText() {
        try (InputStream usageResourceStream = CommandlineOptionsParser.class.getResourceAsStream(USAGE_RESOURCE);){
            String string;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(usageResourceStream, StandardCharsets.UTF_8));){
                string = br.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            return string;
        }
        catch (Exception e) {
            return "Could not load usage text: " + e;
        }
    }

    private int findWidest(List<GherkinDialect> dialects, Function<GherkinDialect, String> getNativeName) {
        return dialects.stream().map(getNativeName).mapToInt(String::length).max().orElse(0);
    }

    private void printDialect(GherkinDialect dialect, int widestLanguage, int widestName, int widestNativeName) {
        String langCode = this.rightPad(dialect.getLanguage(), widestLanguage);
        String name = this.rightPad(dialect.getName(), widestName);
        String nativeName = this.rightPad(dialect.getNativeName(), widestNativeName);
        this.out.println(langCode + name + nativeName);
    }

    private byte printKeywordsFor(GherkinDialect dialect) {
        StringBuilder builder = new StringBuilder();
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        this.addKeywordRow(table, "feature", dialect.getFeatureKeywords());
        this.addKeywordRow(table, "background", dialect.getBackgroundKeywords());
        this.addKeywordRow(table, "scenario", dialect.getScenarioKeywords());
        this.addKeywordRow(table, "scenario outline", dialect.getScenarioOutlineKeywords());
        this.addKeywordRow(table, "examples", dialect.getExamplesKeywords());
        this.addKeywordRow(table, "given", dialect.getGivenKeywords());
        this.addKeywordRow(table, "when", dialect.getWhenKeywords());
        this.addKeywordRow(table, "then", dialect.getThenKeywords());
        this.addKeywordRow(table, "and", dialect.getAndKeywords());
        this.addKeywordRow(table, "but", dialect.getButKeywords());
        this.addCodeKeywordRow(table, "given", dialect.getGivenKeywords());
        this.addCodeKeywordRow(table, "when", dialect.getWhenKeywords());
        this.addCodeKeywordRow(table, "then", dialect.getThenKeywords());
        this.addCodeKeywordRow(table, "and", dialect.getAndKeywords());
        this.addCodeKeywordRow(table, "but", dialect.getButKeywords());
        DataTableFormatter.builder().prefixRow("      ").build().formatTo(DataTable.create(table), builder);
        this.out.println(builder);
        return 0;
    }

    private String rightPad(String text, int maxWidth) {
        int padding = 7;
        int width = maxWidth + padding;
        return String.format("%" + -width + "s", text);
    }

    private void addKeywordRow(List<List<String>> table, String key, List<String> keywords) {
        table.add(Arrays.asList(key, keywords.stream().map(o -> '\"' + o + '\"').collect(Collectors.joining(", "))));
    }

    private void addCodeKeywordRow(List<List<String>> table, String key, List<String> keywords) {
        ArrayList<String> codeKeywordList = new ArrayList<String>(keywords);
        codeKeywordList.remove("* ");
        List<String> codeWords = codeKeywordList.stream().map(keyword -> keyword.replaceAll("[\\s',!]", "")).collect(Collectors.toList());
        this.addKeywordRow(table, key + " (code)", codeWords);
    }
}

