/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.exception.ExceptionUtils;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.runner.Runner;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.RethrowingThrowableCollector;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.createmeta.CreateMeta;
import io.cucumber.messages.TimeConversion;
import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceParsed;
import io.cucumber.plugin.event.TestSourceRead;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.function.Consumer;

public final class CucumberExecutionContext {
    private static final String VERSION = ResourceBundle.getBundle("io.cucumber.core.version").getString("cucumber-jvm.version");
    private static final Logger log = LoggerFactory.getLogger(CucumberExecutionContext.class);
    private final EventBus bus;
    private final ExitStatus exitStatus;
    private final RunnerSupplier runnerSupplier;
    private final RethrowingThrowableCollector collector = new RethrowingThrowableCollector();
    private Instant start;

    public CucumberExecutionContext(EventBus bus, ExitStatus exitStatus, RunnerSupplier runnerSupplier) {
        this.bus = bus;
        this.exitStatus = exitStatus;
        this.runnerSupplier = runnerSupplier;
    }

    public void startTestRun() {
        this.emitMeta();
        this.emitTestRunStarted();
    }

    private void emitMeta() {
        Envelope envelope = new Envelope();
        envelope.setMeta(CreateMeta.createMeta((String)"cucumber-jvm", (String)VERSION, System.getenv()));
        this.bus.send(envelope);
    }

    private void emitTestRunStarted() {
        log.debug(() -> "Sending run test started event");
        this.start = this.bus.getInstant();
        this.bus.send(new TestRunStarted(this.start));
        Envelope envelope = new Envelope();
        envelope.setTestRunStarted(new io.cucumber.messages.types.TestRunStarted(TimeConversion.javaInstantToTimestamp((Instant)this.start)));
        this.bus.send(envelope);
    }

    public void runBeforeAllHooks() {
        Runner runner = this.getRunner();
        this.collector.executeAndThrow(runner::runBeforeAllHooks);
    }

    public void runAfterAllHooks() {
        Runner runner = this.getRunner();
        this.collector.executeAndThrow(runner::runAfterAllHooks);
    }

    public void finishTestRun() {
        log.debug(() -> "Sending test run finished event");
        Throwable cucumberException = this.getThrowable();
        this.emitTestRunFinished(cucumberException);
    }

    public Throwable getThrowable() {
        return this.collector.getThrowable();
    }

    private void emitTestRunFinished(Throwable exception) {
        Instant instant = this.bus.getInstant();
        Result result = new Result(exception != null ? Status.FAILED : this.exitStatus.getStatus(), Duration.between(this.start, instant), exception);
        this.bus.send(new TestRunFinished(instant, result));
        io.cucumber.messages.types.TestRunFinished testRunFinished = new io.cucumber.messages.types.TestRunFinished(exception != null ? ExceptionUtils.printStackTrace(exception) : null, Boolean.valueOf(exception == null && this.exitStatus.isSuccess()), TimeConversion.javaInstantToTimestamp((Instant)instant));
        Envelope envelope = new Envelope();
        envelope.setTestRunFinished(testRunFinished);
        this.bus.send(envelope);
    }

    public void beforeFeature(Feature feature) {
        log.debug(() -> "Sending test source read event for " + feature.getUri());
        this.bus.send(new TestSourceRead(this.bus.getInstant(), feature.getUri(), feature.getSource()));
        this.bus.send(new TestSourceParsed(this.bus.getInstant(), feature.getUri(), Collections.singletonList(feature)));
        this.bus.sendAll(feature.getParseEvents());
    }

    public void runTestCase(Consumer<Runner> execution) {
        Runner runner = this.getRunner();
        this.collector.executeAndThrow(() -> execution.accept(runner));
    }

    private Runner getRunner() {
        return this.collector.executeAndThrow(this.runnerSupplier::get);
    }
}

