/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LanguageParser {
    private static final Logger log = LoggerFactory.getLogger(FeatureParser.class);
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^(\\s*#\\s*language\\s*:\\s*)tl");

    LanguageParser() {
    }

    String parse(String feature) {
        Matcher matcher = LANGUAGE_PATTERN.matcher(feature);
        if (matcher.find()) {
            log.warn(() -> "The ISO 639-1 code for Telugu was changed from tl to te. Please use '# language: te' in your feature files.");
            return matcher.replaceFirst("$1te");
        }
        return feature;
    }
}

