/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.plugin.TestSourceReadResource;
import io.cucumber.core.plugin.URLOutputStream;
import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.StrictAware;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class TestNGFormatter
implements EventListener,
StrictAware {
    private final Writer writer;
    private final Document document;
    private final Element results;
    private final Element suite;
    private final Element test;
    private Element clazz;
    private Element root;
    private TestCase testCase;
    private boolean strict = false;
    private URI currentFeatureFile = null;
    private String previousTestCaseName;
    private int exampleNumber;
    private Instant started;
    private final Map<URI, String> featuresNames = new HashMap<URI, String>();
    private final FeatureParser parser = new FeatureParser(UUID::randomUUID);

    public TestNGFormatter(URL url) throws IOException {
        this.writer = new UTF8OutputStreamWriter(new URLOutputStream(url));
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.results = this.document.createElement("testng-results");
            this.suite = this.document.createElement("suite");
            this.test = this.document.createElement("test");
            this.suite.appendChild(this.test);
            this.results.appendChild(this.suite);
            this.document.appendChild(this.results);
        }
        catch (ParserConfigurationException e) {
            throw new CucumberException("Error initializing DocumentBuilder.", e);
        }
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this::handleTestSourceRead);
        publisher.registerHandlerFor(TestRunStarted.class, this::handleTestRunStarted);
        publisher.registerHandlerFor(TestCaseStarted.class, this::handleTestCaseStarted);
        publisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::handleTestRunFinished);
    }

    private void handleTestRunStarted(TestRunStarted event) {
        this.started = event.getInstant();
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private void handleTestSourceRead(TestSourceRead event) {
        TestSourceReadResource source = new TestSourceReadResource(event);
        this.parser.parseResource(source).ifPresent(feature -> this.featuresNames.put(feature.getUri(), feature.getName()));
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(event.getTestCase().getUri())) {
            this.currentFeatureFile = event.getTestCase().getUri();
            this.previousTestCaseName = "";
            this.exampleNumber = 1;
            this.clazz = this.document.createElement("class");
            this.clazz.setAttribute("name", this.featuresNames.get(event.getTestCase().getUri()));
            this.test.appendChild(this.clazz);
        }
        this.root = this.document.createElement("test-method");
        this.clazz.appendChild(this.root);
        this.testCase = new TestCase(event.getTestCase());
        this.testCase.start(this.root, event.getInstant());
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof PickleStepTestStep) {
            this.testCase.steps.add((PickleStepTestStep)event.getTestStep());
            this.testCase.results.add(event.getResult());
        } else {
            this.testCase.hooks.add(event.getResult());
        }
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        this.testCase.finish(this.document, this.root, event.getInstant());
    }

    private void handleTestRunFinished(TestRunFinished event) {
        try {
            Instant finished = event.getInstant();
            Duration duration = Duration.between(this.started, finished);
            this.results.setAttribute("total", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", ".*")));
            this.results.setAttribute("passed", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", "PASS")));
            this.results.setAttribute("failed", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", "FAIL")));
            this.results.setAttribute("skipped", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", "SKIP")));
            this.suite.setAttribute("name", TestNGFormatter.class.getName());
            this.suite.setAttribute("duration-ms", String.valueOf(duration.toMillis()));
            this.test.setAttribute("name", TestNGFormatter.class.getName());
            this.test.setAttribute("duration-ms", String.valueOf(duration.toMillis()));
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(this.writer);
            DOMSource domSource = new DOMSource(this.document);
            transformer.transform(domSource, streamResult);
            this.closeQuietly(this.writer);
        }
        catch (TransformerException e) {
            throw new CucumberException("Error transforming report.", e);
        }
    }

    private void closeQuietly(Closeable out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getElementsCountByAttribute(Node node, String attributeName, String attributeValue) {
        Node namedItem;
        int count = 0;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            count += this.getElementsCountByAttribute(node.getChildNodes().item(i), attributeName, attributeValue);
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (namedItem = attributes.getNamedItem(attributeName)) != null && namedItem.getNodeValue().matches(attributeValue)) {
            ++count;
        }
        return count;
    }

    final class TestCase {
        private final List<PickleStepTestStep> steps = new ArrayList<PickleStepTestStep>();
        private final List<Result> results = new ArrayList<Result>();
        private final List<Result> hooks = new ArrayList<Result>();
        private final io.cucumber.plugin.event.TestCase testCase;

        TestCase(io.cucumber.plugin.event.TestCase testCase) {
            this.testCase = testCase;
        }

        private void start(Element element, Instant instant) {
            element.setAttribute("name", this.calculateElementName(this.testCase));
            element.setAttribute("started-at", DateTimeFormatter.ISO_INSTANT.format(instant));
        }

        private String calculateElementName(io.cucumber.plugin.event.TestCase testCase) {
            String testCaseName = testCase.getName();
            if (testCaseName.equals(TestNGFormatter.this.previousTestCaseName)) {
                return testCaseName + "_" + ++TestNGFormatter.this.exampleNumber;
            }
            TestNGFormatter.this.previousTestCaseName = testCaseName;
            TestNGFormatter.this.exampleNumber = 1;
            return testCaseName;
        }

        void finish(Document doc, Element element, Instant instant) {
            element.setAttribute("duration-ms", this.calculateTotalDurationString());
            element.setAttribute("finished-at", DateTimeFormatter.ISO_INSTANT.format(instant));
            StringBuilder stringBuilder = new StringBuilder();
            this.addStepAndResultListing(stringBuilder);
            Result skipped = null;
            Result failed = null;
            for (Result result : this.results) {
                if (result.getStatus().is(Status.FAILED) || result.getStatus().is(Status.AMBIGUOUS)) {
                    failed = result;
                }
                if (!result.getStatus().is(Status.UNDEFINED) && !result.getStatus().is(Status.PENDING)) continue;
                skipped = result;
            }
            for (Result result : this.hooks) {
                if (failed != null || !result.getStatus().is(Status.FAILED)) continue;
                failed = result;
            }
            if (failed != null) {
                element.setAttribute("status", "FAIL");
                String stacktrace = this.printStrackTrace(failed);
                Element exception = this.createException(doc, failed.getError().getClass().getName(), stringBuilder.toString(), stacktrace);
                element.appendChild(exception);
            } else if (skipped != null) {
                if (TestNGFormatter.this.strict) {
                    element.setAttribute("status", "FAIL");
                    Element exception = this.createException(doc, "The scenario has pending or undefined step(s)", stringBuilder.toString(), "The scenario has pending or undefined step(s)");
                    element.appendChild(exception);
                } else {
                    element.setAttribute("status", "SKIP");
                }
            } else {
                element.setAttribute("status", "PASS");
            }
        }

        private String printStrackTrace(Result failed) {
            StringWriter stringWriter = new StringWriter();
            failed.getError().printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.toString();
        }

        private String calculateTotalDurationString() {
            Duration totalDuration = Duration.ZERO;
            for (Result r : this.results) {
                totalDuration = totalDuration.plus(r.getDuration());
            }
            for (Result r : this.hooks) {
                totalDuration = totalDuration.plus(r.getDuration());
            }
            return String.valueOf(totalDuration.toMillis());
        }

        private void addStepAndResultListing(StringBuilder sb) {
            for (int i = 0; i < this.steps.size(); ++i) {
                int length = sb.length();
                String resultStatus = "not executed";
                if (i < this.results.size()) {
                    resultStatus = this.results.get(i).getStatus().name().toLowerCase(Locale.ROOT);
                }
                sb.append(this.steps.get(i).getStep().getKeyWord());
                sb.append(this.steps.get(i).getStepText());
                do {
                    sb.append(".");
                } while (sb.length() - length < 76);
                sb.append(resultStatus);
                sb.append("\n");
            }
        }

        private Element createException(Document doc, String clazz, String message, String stacktrace) {
            Element exceptionElement = doc.createElement("exception");
            exceptionElement.setAttribute("class", clazz);
            if (message != null) {
                Element messageElement = doc.createElement("message");
                messageElement.appendChild(doc.createCDATASection(message));
                exceptionElement.appendChild(messageElement);
            }
            Element stacktraceElement = doc.createElement("full-stacktrace");
            stacktraceElement.appendChild(doc.createCDATASection(stacktrace));
            exceptionElement.appendChild(stacktraceElement);
            return exceptionElement;
        }
    }
}

