/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.internal.gherkin.events;

import io.cucumber.core.internal.gherkin.AstBuilder;
import io.cucumber.core.internal.gherkin.Parser;
import io.cucumber.core.internal.gherkin.TokenMatcher;
import io.cucumber.core.internal.gherkin.ast.GherkinDocument;
import io.cucumber.core.internal.gherkin.events.CucumberEvent;
import io.cucumber.core.internal.gherkin.events.GherkinDocumentEvent;
import io.cucumber.core.internal.gherkin.events.PickleEvent;
import io.cucumber.core.internal.gherkin.events.SourceEvent;
import io.cucumber.core.internal.gherkin.pickles.Compiler;
import io.cucumber.core.internal.gherkin.pickles.Pickle;
import java.util.ArrayList;
import java.util.List;

public class Events {
    public static List<CucumberEvent> generate(String data, String uri) {
        return Events.generate(data, uri, new TokenMatcher());
    }

    public static List<CucumberEvent> generate(String data, String uri, String language) {
        return Events.generate(data, uri, new TokenMatcher(language));
    }

    private static List<CucumberEvent> generate(String data, String uri, TokenMatcher tokenMatcher) {
        Parser<GherkinDocument> parser = new Parser<GherkinDocument>(new AstBuilder());
        Compiler compiler = new Compiler();
        ArrayList<CucumberEvent> events = new ArrayList<CucumberEvent>();
        events.add(new SourceEvent(data, uri));
        GherkinDocument document = parser.parse(data, (Parser.ITokenMatcher)tokenMatcher);
        events.add(new GherkinDocumentEvent(uri, document));
        List<Pickle> pickles = compiler.compile(document);
        for (Pickle pickle : pickles) {
            events.add(new PickleEvent(uri, pickle));
        }
        return events;
    }
}

