/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.plugin.NiceAppendable;
import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.StrictAware;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestRunFinished;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class RerunFormatter
implements EventListener,
StrictAware {
    private final NiceAppendable out;
    private final Map<URI, Collection<Integer>> featureAndFailedLinesMapping = new HashMap<URI, Collection<Integer>>();
    private boolean isStrict = false;

    public RerunFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
        publisher.registerHandlerFor(TestRunFinished.class, event -> this.finishReport());
    }

    public void setStrict(boolean strict) {
        this.isStrict = strict;
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        if (!event.getResult().getStatus().isOk(this.isStrict)) {
            this.recordTestFailed(event.getTestCase());
        }
    }

    private void recordTestFailed(TestCase testCase) {
        URI uri = testCase.getUri();
        Collection<Integer> failedTestCaseLines = this.getFailedTestCaseLines(uri);
        failedTestCaseLines.add(testCase.getLine());
    }

    private Collection<Integer> getFailedTestCaseLines(URI uri) {
        return this.featureAndFailedLinesMapping.computeIfAbsent(uri, k -> new ArrayList());
    }

    private void finishReport() {
        for (Map.Entry<URI, Collection<Integer>> entry : this.featureAndFailedLinesMapping.entrySet()) {
            FeatureWithLines featureWithLines = FeatureWithLines.create(TestSourcesModel.relativize(entry.getKey()), entry.getValue());
            this.out.println(featureWithLines.toString());
        }
        this.out.close();
    }
}

