/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import cucumber.api.SnippetType;
import cucumber.runtime.CucumberException;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.order.PickleOrder;
import io.cucumber.core.model.FeatureWithLines;
import io.cucumber.core.options.RuntimeOptions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class RuntimeOptionsBuilder {
    private List<String> parsedTagFilters = new ArrayList<String>();
    private List<Pattern> parsedNameFilters = new ArrayList<Pattern>();
    private Map<URI, Set<Integer>> parsedLineFilters = new HashMap<URI, Set<Integer>>();
    private List<URI> parsedFeaturePaths = new ArrayList<URI>();
    private List<URI> parsedGlue = new ArrayList<URI>();
    private ParsedPluginData parsedPluginData = new ParsedPluginData();
    private List<String> parsedJunitOptions = new ArrayList<String>();
    private boolean parsedIsRerun = false;
    private Integer parsedThreads = null;
    private Boolean parsedDryRun = null;
    private Boolean parsedStrict = null;
    private Boolean parsedMonochrome = null;
    private SnippetType parsedSnippetType = null;
    private Boolean parsedWip = null;
    private PickleOrder parsedPickleOrder = null;
    private Integer parsedCount = null;

    public RuntimeOptionsBuilder addFeature(FeatureWithLines featureWithLines) {
        this.parsedFeaturePaths.add(featureWithLines.uri());
        this.addLineFilters(featureWithLines);
        return this;
    }

    public RuntimeOptionsBuilder addGlue(URI glue) {
        this.parsedGlue.add(glue);
        return this;
    }

    public RuntimeOptionsBuilder addJunitOption(String junitOption) {
        this.parsedJunitOptions.add(junitOption);
        return this;
    }

    private RuntimeOptionsBuilder addLineFilters(FeatureWithLines featureWithLines) {
        URI key = featureWithLines.uri();
        SortedSet<Integer> lines = featureWithLines.lines();
        if (lines.isEmpty()) {
            return null;
        }
        if (this.parsedLineFilters.containsKey(key)) {
            this.parsedLineFilters.get(key).addAll(lines);
        } else {
            this.parsedLineFilters.put(key, new TreeSet<Integer>((Collection<Integer>)lines));
        }
        return this;
    }

    public RuntimeOptionsBuilder addNameFilter(Pattern pattern) {
        this.parsedNameFilters.add(pattern);
        return this;
    }

    public RuntimeOptionsBuilder addPluginName(String name, boolean isAddPlugin) {
        this.parsedPluginData.addPluginName(name, isAddPlugin);
        return this;
    }

    public RuntimeOptionsBuilder addTagFilter(String tagExpression) {
        this.parsedTagFilters.add(tagExpression);
        return this;
    }

    public RuntimeOptions build() {
        return this.build(RuntimeOptions.defaultOptions());
    }

    public RuntimeOptions build(RuntimeOptions runtimeOptions) {
        if (this.parsedThreads != null) {
            runtimeOptions.setThreads(this.parsedThreads);
        }
        if (this.parsedDryRun != null) {
            runtimeOptions.setDryRun(this.parsedDryRun);
        }
        if (this.parsedStrict != null) {
            runtimeOptions.setStrict(this.parsedStrict);
        }
        if (this.parsedMonochrome != null) {
            runtimeOptions.setMonochrome(this.parsedMonochrome);
        }
        if (this.parsedSnippetType != null) {
            runtimeOptions.setSnippetType(this.parsedSnippetType);
        }
        if (this.parsedWip != null) {
            runtimeOptions.setWip(this.parsedWip);
        }
        if (this.parsedPickleOrder != null) {
            runtimeOptions.setPickleOrder(this.parsedPickleOrder);
        }
        if (this.parsedCount != null) {
            runtimeOptions.setCount(this.parsedCount);
        }
        if (this.parsedIsRerun || !this.parsedFeaturePaths.isEmpty()) {
            runtimeOptions.setFeaturePaths(Collections.emptyList());
            runtimeOptions.setLineFilters(Collections.emptyMap());
        }
        if (!(this.parsedTagFilters.isEmpty() && this.parsedNameFilters.isEmpty() && this.parsedLineFilters.isEmpty())) {
            runtimeOptions.setTagFilters(this.parsedTagFilters);
            runtimeOptions.setNameFilters(this.parsedNameFilters);
            runtimeOptions.setLineFilters(this.parsedLineFilters);
        }
        if (!this.parsedFeaturePaths.isEmpty()) {
            runtimeOptions.setFeaturePaths(this.parsedFeaturePaths);
        }
        if (!this.parsedGlue.isEmpty()) {
            runtimeOptions.setGlue(this.parsedGlue);
        }
        if (!this.parsedJunitOptions.isEmpty()) {
            runtimeOptions.setJunitOptions(this.parsedJunitOptions);
        }
        this.parsedPluginData.updatePluginFormatterNames(runtimeOptions.getPluginFormatterNames());
        this.parsedPluginData.updatePluginStepDefinitionReporterNames(runtimeOptions.getPluginStepDefinitionReporterNames());
        this.parsedPluginData.updatePluginSummaryPrinterNames(runtimeOptions.getPluginSummaryPrinterNames());
        return runtimeOptions;
    }

    public RuntimeOptionsBuilder setCount(int count) {
        this.parsedCount = count;
        return this;
    }

    public RuntimeOptionsBuilder setDryRun(boolean dryRun) {
        this.parsedDryRun = dryRun;
        return this;
    }

    public RuntimeOptionsBuilder setDryRun() {
        return this.setDryRun(true);
    }

    public void setIsRerun(boolean isRerun) {
        this.parsedIsRerun = isRerun;
    }

    public RuntimeOptionsBuilder setMonochrome(boolean monochrome) {
        this.parsedMonochrome = monochrome;
        return this;
    }

    public RuntimeOptionsBuilder setMonochrome() {
        return this.setMonochrome(true);
    }

    public RuntimeOptionsBuilder setPickleOrder(PickleOrder pickleOrder) {
        this.parsedPickleOrder = pickleOrder;
        return this;
    }

    public RuntimeOptionsBuilder setSnippetType(SnippetType snippetType) {
        this.parsedSnippetType = snippetType;
        return this;
    }

    public RuntimeOptionsBuilder setStrict() {
        return this.setStrict(true);
    }

    public RuntimeOptionsBuilder setStrict(boolean strict) {
        this.parsedStrict = strict;
        return this;
    }

    public RuntimeOptionsBuilder setThreads(int threads) {
        this.parsedThreads = threads;
        return this;
    }

    public RuntimeOptionsBuilder setWip(boolean wip) {
        this.parsedWip = wip;
        return this;
    }

    public RuntimeOptionsBuilder addDefaultSummaryPrinterIfNotPresent() {
        this.parsedPluginData.addDefaultSummaryPrinterIfNotPresent();
        return this;
    }

    public RuntimeOptionsBuilder addDefaultFormatterIfNotPresent() {
        this.parsedPluginData.addDefaultFormatterIfNotPresent();
        return this;
    }

    private static class ParsedOptionNames {
        private List<String> names = new ArrayList<String>();
        private boolean clobber = false;

        private ParsedOptionNames() {
        }

        void addName(String name, boolean isAddOption) {
            this.names.add(name);
            if (!isAddOption) {
                this.clobber = true;
            }
        }

        void updateNameList(List<String> nameList) {
            if (!this.names.isEmpty()) {
                if (this.clobber) {
                    nameList.clear();
                }
                nameList.addAll(this.names);
            }
        }
    }

    private static class ParsedPluginData {
        ParsedOptionNames formatterNames = new ParsedOptionNames();
        ParsedOptionNames stepDefinitionReporterNames = new ParsedOptionNames();
        ParsedOptionNames summaryPrinterNames = new ParsedOptionNames();

        private ParsedPluginData() {
        }

        void addPluginName(String name, boolean isAddPlugin) {
            if (PluginFactory.isStepDefinitionReporterName(name)) {
                this.stepDefinitionReporterNames.addName(name, isAddPlugin);
            } else if (PluginFactory.isSummaryPrinterName(name)) {
                this.summaryPrinterNames.addName(name, isAddPlugin);
            } else if (PluginFactory.isFormatterName(name)) {
                this.formatterNames.addName(name, isAddPlugin);
            } else {
                throw new CucumberException("Unrecognized plugin: " + name);
            }
        }

        void updatePluginFormatterNames(List<String> pluginFormatterNames) {
            this.formatterNames.updateNameList(pluginFormatterNames);
        }

        void updatePluginStepDefinitionReporterNames(List<String> pluginStepDefinitionReporterNames) {
            this.stepDefinitionReporterNames.updateNameList(pluginStepDefinitionReporterNames);
        }

        void updatePluginSummaryPrinterNames(List<String> pluginSummaryPrinterNames) {
            this.summaryPrinterNames.updateNameList(pluginSummaryPrinterNames);
        }

        void addDefaultSummaryPrinterIfNotPresent() {
            if (this.summaryPrinterNames.names.isEmpty()) {
                this.summaryPrinterNames.addName("default_summary", false);
            }
        }

        void addDefaultFormatterIfNotPresent() {
            if (this.formatterNames.names.isEmpty()) {
                this.formatterNames.addName("progress", false);
            }
        }
    }
}

