/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.formatter.StrictAware;
import cucumber.runtime.CucumberException;
import cucumber.runtime.formatter.TestSourcesModel;
import cucumber.runtime.formatter.URLOutputStream;
import cucumber.runtime.formatter.UTF8OutputStreamWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class TestNGFormatter
implements EventListener,
StrictAware {
    private final Writer writer;
    private final Document document;
    private final Element results;
    private final Element suite;
    private final Element test;
    private final TestSourcesModel testSources = new TestSourcesModel();
    private Element clazz;
    private Element root;
    private TestCase testCase;
    private boolean strict = false;
    private String currentFeatureFile = null;
    private String previousTestCaseName;
    private int exampleNumber;
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        @Override
        public void receive(TestSourceRead event) {
            TestNGFormatter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        @Override
        public void receive(TestCaseStarted event) {
            TestNGFormatter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            TestNGFormatter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<TestCaseFinished> caseFinishedHandler = new EventHandler<TestCaseFinished>(){

        @Override
        public void receive(TestCaseFinished event) {
            TestNGFormatter.this.handleTestCaseFinished();
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            TestNGFormatter.this.finishReport();
        }
    };

    public TestNGFormatter(URL url) throws IOException {
        this.writer = new UTF8OutputStreamWriter(new URLOutputStream(url));
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.results = this.document.createElement("testng-results");
            this.suite = this.document.createElement("suite");
            this.test = this.document.createElement("test");
            this.suite.appendChild(this.test);
            this.results.appendChild(this.suite);
            this.document.appendChild(this.results);
        }
        catch (ParserConfigurationException e) {
            throw new CucumberException("Error initializing DocumentBuilder.", e);
        }
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    @Override
    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(event.testCase.getUri())) {
            this.currentFeatureFile = event.testCase.getUri();
            this.previousTestCaseName = "";
            this.exampleNumber = 1;
            this.clazz = this.document.createElement("class");
            this.clazz.setAttribute("name", this.testSources.getFeature(event.testCase.getUri()).getName());
            this.test.appendChild(this.clazz);
        }
        this.root = this.document.createElement("test-method");
        this.clazz.appendChild(this.root);
        this.testCase = new TestCase(event.testCase);
        this.testCase.start(this.root);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.testStep instanceof PickleStepTestStep) {
            this.testCase.steps.add((PickleStepTestStep)event.testStep);
            this.testCase.results.add(event.result);
        } else {
            this.testCase.hooks.add(event.result);
        }
    }

    private void handleTestCaseFinished() {
        this.testCase.finish(this.document, this.root);
    }

    private void finishReport() {
        try {
            this.results.setAttribute("total", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", ".*")));
            this.results.setAttribute("passed", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", "PASS")));
            this.results.setAttribute("failed", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", "FAIL")));
            this.results.setAttribute("skipped", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", "SKIP")));
            this.suite.setAttribute("name", TestNGFormatter.class.getName());
            this.suite.setAttribute("duration-ms", this.getTotalDuration(this.suite.getElementsByTagName("test-method")));
            this.test.setAttribute("name", TestNGFormatter.class.getName());
            this.test.setAttribute("duration-ms", this.getTotalDuration(this.suite.getElementsByTagName("test-method")));
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(this.writer);
            DOMSource domSource = new DOMSource(this.document);
            transformer.transform(domSource, streamResult);
            this.closeQuietly(this.writer);
        }
        catch (TransformerException e) {
            throw new CucumberException("Error transforming report.", e);
        }
    }

    private void closeQuietly(Closeable out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getElementsCountByAttribute(Node node, String attributeName, String attributeValue) {
        Node namedItem;
        int count = 0;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            count += this.getElementsCountByAttribute(node.getChildNodes().item(i), attributeName, attributeValue);
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (namedItem = attributes.getNamedItem(attributeName)) != null && namedItem.getNodeValue().matches(attributeValue)) {
            ++count;
        }
        return count;
    }

    private String getTotalDuration(NodeList testCaseNodes) {
        long totalDuration = 0L;
        for (int i = 0; i < testCaseNodes.getLength(); ++i) {
            try {
                String duration = testCaseNodes.item(i).getAttributes().getNamedItem("duration-ms").getNodeValue();
                totalDuration += Long.parseLong(duration);
                continue;
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new CucumberException(e);
            }
        }
        return String.valueOf(totalDuration);
    }

    final class TestCase {
        private final List<PickleStepTestStep> steps = new ArrayList<PickleStepTestStep>();
        private final List<Result> results = new ArrayList<Result>();
        private final List<Result> hooks = new ArrayList<Result>();
        private final cucumber.api.TestCase testCase;
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

        TestCase(cucumber.api.TestCase testCase) {
            this.testCase = testCase;
        }

        private void start(Element element) {
            element.setAttribute("name", this.calculateElementName(this.testCase));
            element.setAttribute("started-at", this.dateFormat.format(new Date()));
        }

        private String calculateElementName(cucumber.api.TestCase testCase) {
            String testCaseName = testCase.getName();
            if (testCaseName.equals(TestNGFormatter.this.previousTestCaseName)) {
                return testCaseName + "_" + ++TestNGFormatter.this.exampleNumber;
            }
            TestNGFormatter.this.previousTestCaseName = testCaseName;
            TestNGFormatter.this.exampleNumber = 1;
            return testCaseName;
        }

        void finish(Document doc, Element element) {
            element.setAttribute("duration-ms", this.calculateTotalDurationString());
            element.setAttribute("finished-at", this.dateFormat.format(new Date()));
            StringBuilder stringBuilder = new StringBuilder();
            this.addStepAndResultListing(stringBuilder);
            Result skipped = null;
            Result failed = null;
            for (Result result : this.results) {
                if (result.is(Result.Type.FAILED) || result.is(Result.Type.AMBIGUOUS)) {
                    failed = result;
                }
                if (!result.is(Result.Type.UNDEFINED) && !result.is(Result.Type.PENDING)) continue;
                skipped = result;
            }
            for (Result result : this.hooks) {
                if (failed != null || !result.is(Result.Type.FAILED)) continue;
                failed = result;
            }
            if (failed != null) {
                element.setAttribute("status", "FAIL");
                StringWriter stringWriter = new StringWriter();
                failed.getError().printStackTrace(new PrintWriter(stringWriter));
                Element exception = this.createException(doc, failed.getError().getClass().getName(), stringBuilder.toString(), stringWriter.toString());
                element.appendChild(exception);
            } else if (skipped != null) {
                if (TestNGFormatter.this.strict) {
                    element.setAttribute("status", "FAIL");
                    Element exception = this.createException(doc, "The scenario has pending or undefined step(s)", stringBuilder.toString(), "The scenario has pending or undefined step(s)");
                    element.appendChild(exception);
                } else {
                    element.setAttribute("status", "SKIP");
                }
            } else {
                element.setAttribute("status", "PASS");
            }
        }

        private String calculateTotalDurationString() {
            long totalDurationNanos = 0L;
            for (Result r : this.results) {
                totalDurationNanos += r.getDuration().longValue();
            }
            for (Result r : this.hooks) {
                totalDurationNanos += r.getDuration().longValue();
            }
            return String.valueOf(TimeUnit.NANOSECONDS.toMillis(totalDurationNanos));
        }

        private void addStepAndResultListing(StringBuilder sb) {
            for (int i = 0; i < this.steps.size(); ++i) {
                int length = sb.length();
                String resultStatus = "not executed";
                if (i < this.results.size()) {
                    resultStatus = this.results.get(i).getStatus().lowerCaseName();
                }
                sb.append(this.getKeywordFromSource(this.steps.get(i).getStepLine()));
                sb.append(this.steps.get(i).getStepText());
                do {
                    sb.append(".");
                } while (sb.length() - length < 76);
                sb.append(resultStatus);
                sb.append("\n");
            }
        }

        private String getKeywordFromSource(int stepLine) {
            return TestNGFormatter.this.testSources.getKeywordFromSource(TestNGFormatter.this.currentFeatureFile, stepLine);
        }

        private Element createException(Document doc, String clazz, String message, String stacktrace) {
            Element exceptionElement = doc.createElement("exception");
            exceptionElement.setAttribute("class", clazz);
            if (message != null) {
                Element messageElement = doc.createElement("message");
                messageElement.appendChild(doc.createCDATASection(message));
                exceptionElement.appendChild(messageElement);
            }
            Element stacktraceElement = doc.createElement("full-stacktrace");
            stacktraceElement.appendChild(doc.createCDATASection(stacktrace));
            exceptionElement.appendChild(stacktraceElement);
            return exceptionElement;
        }
    }
}

