/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.createmeta;

import io.cucumber.createmeta.VariableExpression;
import io.cucumber.createmeta.internal.com.eclipsesource.json.Json;
import io.cucumber.createmeta.internal.com.eclipsesource.json.JsonObject;
import io.cucumber.createmeta.internal.com.eclipsesource.json.JsonValue;
import io.cucumber.messages.ProtocolVersion;
import io.cucumber.messages.types.Ci;
import io.cucumber.messages.types.Git;
import io.cucumber.messages.types.Meta;
import io.cucumber.messages.types.Product;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;

public final class CreateMeta {
    private static final JsonObject CI_DICT;
    private static final String JSON_PATH = "/io/cucumber/createmeta/ciDict.json";

    private CreateMeta() {
    }

    public static Meta createMeta(String implementationName, String implementationVersion, Map<String, String> env) {
        return new Meta(ProtocolVersion.getVersion(), new Product(implementationName, implementationVersion), new Product(System.getProperty("java.vm.name"), System.getProperty("java.vm.version")), new Product(System.getProperty("os.name"), null), new Product(System.getProperty("os.arch"), null), CreateMeta.detectCI(env));
    }

    public static String removeUserInfoFromUrl(String value) {
        if (value == null) {
            return null;
        }
        try {
            URI uri = URI.create(value);
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toASCIIString();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return value;
        }
    }

    static Ci detectCI(Map<String, String> env) {
        ArrayList<Ci> detected = new ArrayList<Ci>();
        for (JsonObject.Member envEntry : CI_DICT) {
            Ci ci = CreateMeta.createCi(envEntry.getName(), envEntry.getValue().asObject(), env);
            if (ci == null) continue;
            detected.add(ci);
        }
        return detected.size() == 1 ? (Ci)detected.get(0) : null;
    }

    private static Ci createCi(String name, JsonObject ci, Map<String, String> env) {
        String url = VariableExpression.evaluate(CreateMeta.getString(ci, "url"), env);
        if (url == null) {
            return null;
        }
        JsonObject git = ci.get("git").asObject();
        String buildNumber = VariableExpression.evaluate(CreateMeta.getString(ci, "buildNumber"), env);
        String remote = CreateMeta.removeUserInfoFromUrl(VariableExpression.evaluate(CreateMeta.getString(git, "remote"), env));
        String revision = VariableExpression.evaluate(CreateMeta.getString(git, "revision"), env);
        String branch = VariableExpression.evaluate(CreateMeta.getString(git, "branch"), env);
        String tag = VariableExpression.evaluate(CreateMeta.getString(git, "tag"), env);
        return new Ci(name, url, buildNumber, new Git(remote, revision, branch, tag));
    }

    private static String getString(JsonObject json, String name) {
        JsonValue val = json.get(name);
        if (val == null) {
            throw new RuntimeException(String.format("Missing %s property in %s", name, json.toString()));
        }
        return val.isNull() ? null : val.asString();
    }

    static {
        try (InputStreamReader reader = new InputStreamReader(CreateMeta.class.getResourceAsStream(JSON_PATH), StandardCharsets.UTF_8);){
            CI_DICT = Json.parse(reader).asObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse /io/cucumber/createmeta/ciDict.json", e);
        }
    }
}

