/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events.exporter.kafka;

import com.google.common.collect.Sets;
import io.confluent.telemetry.events.exporter.Exporter;
import io.confluent.telemetry.events.exporter.ExporterConfig;
import io.confluent.telemetry.events.exporter.kafka.KafkaExporterConfig;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaExporter<T>
implements Exporter<T> {
    private static final Logger log = LoggerFactory.getLogger(KafkaExporter.class);
    private static final int ERROR_LOG_INTERVAL_MS = 5000;
    private final Function<Properties, Producer<String, byte[]>> producerFactory;
    protected final AtomicLong droppedEventCount = new AtomicLong();
    protected final AtomicReference<Exception> droppedEventException = new AtomicReference();
    protected Function<T, ProducerRecord<String, byte[]>> responseDeserializer;
    protected long lastLoggedTimestamp = 0L;
    protected long lastLoggedCount = 0L;
    private boolean isTopicCreated = false;
    private Properties adminClientProperties;
    protected String topicName;
    private boolean createTopic;
    private int topicReplicas;
    private int topicPartitions;
    private Map<String, String> topicConfig;
    private Producer<String, byte[]> producer;
    protected KafkaExporterConfig config;
    private volatile boolean isClosed = false;
    protected volatile Predicate<T> filter = e -> true;

    public KafkaExporter() {
        this(props -> new KafkaProducer(Objects.requireNonNull(props)));
    }

    public KafkaExporter(Function<Properties, Producer<String, byte[]>> producerFactory) {
        this.producerFactory = producerFactory;
    }

    public void configure(Map<String, ?> configs) {
        this.config = new KafkaExporterConfig(configs);
        this.adminClientProperties = Objects.requireNonNull(this.config.getProducerProperties());
        this.topicName = Objects.requireNonNull(this.config.getTopicName());
        this.topicConfig = Objects.requireNonNull(this.config.getTopicConfig());
        this.createTopic = this.config.isCreateTopic();
        this.topicReplicas = this.config.getTopicReplicas();
        this.topicPartitions = this.config.getTopicPartitions();
        this.producer = this.producerFactory.apply(this.config.getProducerProperties());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ensureTopic() {
        try (AdminClient adminClient = AdminClient.create((Properties)this.adminClientProperties);){
            try {
                adminClient.describeTopics(Collections.singleton(this.topicName)).all().get();
                log.debug("Telemetry topic {} already exists", (Object)this.topicName);
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof UnknownTopicOrPartitionException)) {
                    log.warn(e.getMessage());
                    throw e;
                }
                adminClient.createTopics(Collections.singleton(new NewTopic(this.topicName, this.topicPartitions, (short)this.topicReplicas).configs(this.topicConfig))).all().get();
                log.info("Created telemetry topic {}", (Object)this.topicName);
            }
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TopicExistsException) {
                log.info("Attempted to create telemetry topic {} but the topic was already created. This may happen the first time the reporter is started and multiple brokers attempt to create the topic simultaneously.", (Object)this.topicName);
                return true;
            }
            log.error("Error checking or creating telemetry topic", e.getCause());
            return false;
        }
        catch (InterruptedException e) {
            log.warn("Topic initialization interrupted", e.getCause());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(T data) {
        try {
            if (!this.maybeCreateTopic()) {
                return;
            }
            Producer<String, byte[]> producer = this.producer;
            synchronized (producer) {
                long now;
                long droppedCount;
                long droppedDelta;
                if (!Thread.currentThread().isInterrupted() && !this.isClosed) {
                    log.trace("Generated telemetry message : {}", (Object)data.toString());
                    this.producer.send(this.responseDeserializer.apply(data), (metadata, exception) -> {
                        if (exception != null) {
                            this.droppedEventCount.incrementAndGet();
                            this.droppedEventException.compareAndSet(null, exception);
                        }
                    });
                }
                if ((droppedDelta = (droppedCount = this.droppedEventCount.get()) - this.lastLoggedCount) > 0L && this.lastLoggedTimestamp + 5000L < (now = Clock.systemUTC().millis())) {
                    log.warn("Failed to produce {} telemetry messages", (Object)droppedDelta, this.droppedEventException.getAndSet(null));
                    this.lastLoggedTimestamp = now;
                    this.lastLoggedCount = droppedCount;
                }
            }
        }
        catch (InterruptException interruptException) {
            // empty catch block
        }
    }

    private synchronized boolean maybeCreateTopic() {
        if (this.createTopic) {
            if (!this.isTopicCreated) {
                this.isTopicCreated = this.ensureTopic();
            }
            return this.isTopicCreated;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.producer != null) {
            Producer<String, byte[]> producer = this.producer;
            synchronized (producer) {
                this.isClosed = true;
                this.producer.close(Duration.ofMillis(0L));
            }
        }
    }

    public Set<String> reconfigurableConfigs() {
        return Sets.union(ExporterConfig.RECONFIGURABLES, KafkaExporterConfig.RECONFIGURABLE_CONFIGS);
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
    }

    public Producer<String, byte[]> producer() {
        return this.producer;
    }
}

