/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events.exporter.kafka;

import com.google.common.collect.Sets;
import io.confluent.telemetry.events.exporter.Exporter;
import io.confluent.telemetry.events.exporter.ExporterConfig;
import io.confluent.telemetry.events.exporter.kafka.KafkaExporterConfig;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncKafkaExporter<T>
implements Exporter<T> {
    private static final Logger log = LoggerFactory.getLogger(AsyncKafkaExporter.class);
    private static final int ERROR_LOG_INTERVAL_MS = 5000;
    protected final AtomicLong droppedEventCount = new AtomicLong();
    protected final AtomicReference<Exception> droppedEventException = new AtomicReference();
    protected Function<T, ProducerRecord<String, byte[]>> dataSerializer;
    protected long lastLoggedTimestamp = 0L;
    protected long lastLoggedCount = 0L;
    private boolean isTopicCreated = false;
    private Properties adminClientProperties;
    protected String topicName;
    private boolean createTopic;
    private int topicReplicas;
    private int topicPartitions;
    private Map<String, String> topicConfig;
    private Producer<String, byte[]> producer;
    private KafkaExporterConfig config;
    private volatile boolean isClosed = false;
    private BlockingQueue<T> buffer;
    private ExecutorService service;
    private static final int BUFFER_SIZE = 1000;

    public void configure(Map<String, ?> configs) {
        this.config = new KafkaExporterConfig(configs);
        this.adminClientProperties = Objects.requireNonNull(this.config.getProducerProperties());
        this.topicName = Objects.requireNonNull(this.config.getTopicName());
        this.topicConfig = Objects.requireNonNull(this.config.getTopicConfig());
        this.createTopic = this.config.isCreateTopic();
        this.topicReplicas = this.config.getTopicReplicas();
        this.topicPartitions = this.config.getTopicPartitions();
        this.producer = configs.containsKey("mockproducer") ? new MockProducer() : new KafkaProducer(Objects.requireNonNull(this.config.getProducerProperties()));
        this.buffer = new ArrayBlockingQueue<T>(1000);
        this.service = Executors.newFixedThreadPool(1);
        this.service.submit(this::consumeAndEmit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ensureTopic() {
        try (AdminClient adminClient = AdminClient.create((Properties)this.adminClientProperties);){
            try {
                adminClient.describeTopics(Collections.singleton(this.topicName)).all().get();
                log.debug("Metrics reporter topic {} already exists", (Object)this.topicName);
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof UnknownTopicOrPartitionException)) {
                    log.warn(e.getMessage());
                    throw e;
                }
                adminClient.createTopics(Collections.singleton(new NewTopic(this.topicName, this.topicPartitions, (short)this.topicReplicas).configs(this.topicConfig))).all().get();
                log.info("Created events emitter topic {}", (Object)this.topicName);
            }
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException e) {
            log.error("Error checking or creating metrics topic", e.getCause());
            return false;
        }
        catch (InterruptedException e) {
            log.warn("Confluent metrics reporter topic initialization interrupted");
            return false;
        }
    }

    @Override
    public void emit(T event) {
        try {
            this.buffer.put(event);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void consumeAndEmit() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                T event = this.buffer.take();
                this.produce(event);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private void produce(T data) {
        long now;
        long droppedCount;
        long droppedDelta;
        if (!this.maybeCreateTopic()) {
            return;
        }
        if (!Thread.currentThread().isInterrupted() && !this.isClosed) {
            log.trace("Generated metric message : {}", (Object)data.toString());
            this.producer.send(this.dataSerializer.apply(data), (metadata, exception) -> {
                if (exception != null) {
                    this.droppedEventCount.incrementAndGet();
                    this.droppedEventException.compareAndSet(null, exception);
                }
            });
        }
        if ((droppedDelta = (droppedCount = this.droppedEventCount.get()) - this.lastLoggedCount) > 0L && this.lastLoggedTimestamp + 5000L < (now = Clock.systemUTC().millis())) {
            log.warn("Failed to produce {} metrics messages", (Object)droppedDelta, this.droppedEventException.getAndSet(null));
            this.lastLoggedTimestamp = now;
            this.lastLoggedCount = droppedCount;
        }
    }

    private boolean maybeCreateTopic() {
        if (this.createTopic) {
            if (!this.isTopicCreated) {
                this.isTopicCreated = this.ensureTopic();
            }
            return this.isTopicCreated;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.producer != null) {
            Producer<String, byte[]> producer = this.producer;
            synchronized (producer) {
                this.isClosed = true;
                this.producer.close(Duration.ofMillis(0L));
            }
        }
    }

    public Set<String> reconfigurableConfigs() {
        return Sets.union(ExporterConfig.RECONFIGURABLES, KafkaExporterConfig.RECONFIGURABLE_CONFIGS);
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
    }

    public void setProducer(Producer<String, byte[]> producer) {
        this.producer = producer;
    }
}

