/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events;

import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import io.confluent.telemetry.events.EventEmitterConfig;
import io.confluent.telemetry.events.exporter.Exporter;
import io.confluent.telemetry.events.exporter.kafka.EventAsyncKafkaExporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEmitterImpl
implements EventEmitter,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(EventEmitterImpl.class);
    private Map<String, String> eventLabels = new HashMap<String, String>();
    private EventEmitterConfig eventEmitterConfig;
    private final List<Exporter<Event>> eventExporters = new ArrayList<Exporter<Event>>(0);

    public EventEmitterImpl(Map<String, ?> configs) {
        this.configure(configs);
    }

    public void emit(Event event) throws RuntimeException {
        for (String key : this.eventLabels.keySet()) {
            event.setExtension(key, this.eventLabels.get(key));
        }
        this.eventExporters.forEach(eventExporter -> eventExporter.emit(event));
    }

    public void setEventLabels(Map<String, String> labels) {
        this.eventLabels.clear();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            if (Event.isValidExtensionName((String)entry.getKey())) {
                this.eventLabels.put(entry.getKey(), entry.getValue());
                continue;
            }
            log.trace("Invalid event extension, {}:{}", (Object)entry.getKey(), (Object)entry.getValue());
            if (entry.getKey().length() > 20) {
                log.trace("Cannot convert event extension that is longer than 20 -> dropping label ({}:{}) because cloudevent spec disallows extensions with key longer than 20 chars", (Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            this.eventLabels.put(this.convertExtension(entry.getKey()), entry.getValue());
        }
    }

    private String convertExtension(String ext) {
        char[] arr = ext.toCharArray();
        StringBuilder strb = new StringBuilder();
        for (char c : arr) {
            if (Character.isAlphabetic(c)) {
                strb.append(Character.toLowerCase(c));
                continue;
            }
            if (!Character.isDigit(c)) continue;
            strb.append(c);
        }
        return strb.toString();
    }

    public void configure(Map<String, ?> configs) {
        this.eventEmitterConfig = new EventEmitterConfig(configs);
        Map<String, Map<String, Object>> eventExporterConfigs = this.eventEmitterConfig.getNonInternalExporterConfigs(EventEmitterConfig.EventType.events);
        if (eventExporterConfigs == null || eventExporterConfigs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : eventExporterConfigs.entrySet()) {
            if (!this.eventEmitterConfig.isKafkaExporter(entry.getValue())) continue;
            EventAsyncKafkaExporter ke = new EventAsyncKafkaExporter();
            ke.configure(entry.getValue());
            this.eventExporters.add(ke);
        }
    }

    public void close() {
        this.eventExporters.forEach(exporter -> {
            try {
                log.info("Closing exporter {}", (Object)exporter.getClass().getCanonicalName());
                exporter.close();
            }
            catch (Exception e) {
                log.error("Error when closing " + exporter.getClass().getCanonicalName(), (Throwable)e);
            }
        });
    }
}

