/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.exceptions;

import io.confluent.rest.RestConfig;
import io.confluent.rest.entities.ErrorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public abstract class DebuggableExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    RestConfig restConfig;
    @Context
    HttpHeaders headers;

    public DebuggableExceptionMapper(RestConfig restConfig) {
        this.restConfig = restConfig;
    }

    public Response.ResponseBuilder createResponse(Throwable exc, int errorCode, Response.Status status, String msg) {
        String readableMessage = msg;
        if (this.restConfig != null && this.restConfig.getBoolean("debug").booleanValue()) {
            readableMessage = readableMessage + " " + exc.getClass().getName() + ": " + exc.getMessage();
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream stream = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());
                exc.printStackTrace(stream);
                stream.close();
                os.close();
                readableMessage = readableMessage + System.lineSeparator() + os.toString(StandardCharsets.UTF_8.name());
            }
            catch (IOException os) {
                // empty catch block
            }
        }
        ErrorMessage message = new ErrorMessage(errorCode, readableMessage);
        return Response.status((Response.Status)status).entity((Object)message);
    }
}

