/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.monitoring.common;

import io.confluent.shaded.monitoring.record.Monitoring;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(MonitoringMessageUtil.class);

    public static Monitoring.MonitoringMessage baseMonitoringMessage() {
        return Monitoring.MonitoringMessage.newBuilder().setWindow(-1L).setPartition(-1).setMinWindow(-1L).setMaxWindow(-1L).setSamplePeriod(-1L).build();
    }

    public static int partitionFor(Monitoring.MonitoringMessage message, int numPartitions) {
        if (!Monitoring.ClientType.CONTROLCENTER.equals(message.getClientType())) {
            return Math.abs(Objects.hash(message.getClusterId(), message.getClientId(), message.getTopic(), message.getPartition()) % numPartitions);
        }
        int partition = message.getPartition();
        if (partition >= numPartitions || partition < 0) {
            log.error("partition={} invalid, expected partition >= 0 and < {}", (Object)partition, (Object)numPartitions);
            partition %= numPartitions;
        }
        return partition;
    }
}

