/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.monitoring.clients.interceptor;

import io.confluent.monitoring.clients.interceptor.MonitoringInterceptor;
import io.confluent.shaded.com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringConsumerInterceptor<K, V>
implements ConsumerInterceptor<K, V>,
ClusterResourceListener {
    private static final Logger log = LoggerFactory.getLogger(MonitoringConsumerInterceptor.class);
    private volatile ClusterResource clusterResource;
    private volatile MonitoringInterceptor monitoringInterceptor;
    private String groupId = "";
    private Map<String, ?> configs;
    protected boolean enabled = true;

    public void configure(Map<String, ?> configs) {
        String isolationLevel;
        this.configs = configs;
        Object groupIdValue = configs.get("group.id");
        if (groupIdValue instanceof String) {
            this.groupId = (String)groupIdValue;
        }
        if (configs.containsKey("isolation.level") && !"read_uncommitted".equals(isolationLevel = configs.get("isolation.level").toString().toLowerCase(Locale.ROOT))) {
            log.error("IsolationLevel={} not supported. monitoring disabled", (Object)isolationLevel);
            this.enabled = false;
        }
        log.debug("configure=finished groupId={}", (Object)this.groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        if (this.enabled) {
            if (this.monitoringInterceptor == null) {
                MonitoringConsumerInterceptor monitoringConsumerInterceptor = this;
                synchronized (monitoringConsumerInterceptor) {
                    if (this.monitoringInterceptor == null) {
                        log.info("creating interceptor");
                        Preconditions.checkState(this.clusterResource != null, "clusterResource is not defined");
                        Preconditions.checkState(this.configs != null, "consumer interceptor is not configured");
                        MonitoringInterceptor interceptor = MonitoringInterceptor.createForConsumer(this.clusterResource.clusterId(), this.groupId, this.configs);
                        interceptor.start();
                        this.monitoringInterceptor = interceptor;
                    }
                }
            }
            for (ConsumerRecord record : records) {
                int size = Math.max(record.serializedKeySize(), 0) + Math.max(record.serializedValueSize(), 0);
                long latency = System.currentTimeMillis() - record.timestamp();
                this.monitoringInterceptor.recordMessageMetric(record.topic(), record.partition(), record.timestamp(), size, record.checksum(), latency);
            }
        }
        return records;
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
    }

    public void close() {
        log.debug("closing");
        if (this.monitoringInterceptor != null) {
            this.monitoringInterceptor.shutdown();
        }
    }

    public void onUpdate(ClusterResource clusterResource) {
        log.debug("cluster updated");
        this.clusterResource = clusterResource;
    }
}

